/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.type;

import com.aspectran.core.context.rule.type.ContentType;

public enum TransformType {
    NONE("none"),
    CUSTOM("custom"),
    TEXT("text"),
    APON("apon"),
    JSON("json"),
    XML("xml"),
    XSL("xsl");

    private final String alias;

    private TransformType(String alias) {
        this.alias = alias;
    }

    public String toString() {
        return this.alias;
    }

    public static TransformType resolve(String alias) {
        for (TransformType type : TransformType.values()) {
            if (!type.alias.equals(alias)) continue;
            return type;
        }
        return null;
    }

    public static TransformType resolve(ContentType contentType) {
        if (contentType == ContentType.TEXT_PLAIN) {
            return TEXT;
        }
        if (contentType == ContentType.APPLICATION_APON) {
            return APON;
        }
        if (contentType == ContentType.APPLICATION_JSON) {
            return JSON;
        }
        if (contentType == ContentType.APPLICATION_XML) {
            return XML;
        }
        return null;
    }
}

