/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.MultiValueMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LinkedMultiValueMap<K, V>
extends LinkedHashMap<K, List<V>>
implements MultiValueMap<K, V>,
Serializable {
    private static final long serialVersionUID = -9081293088810769730L;

    public LinkedMultiValueMap() {
    }

    public LinkedMultiValueMap(int initialCapacity) {
        super(initialCapacity);
    }

    public LinkedMultiValueMap(Map<K, List<V>> otherMap) {
        super(otherMap);
    }

    @Override
    public void add(K key, V value) {
        List values = this.computeIfAbsent(key, k -> new LinkedList());
        values.add(value);
    }

    @Override
    public V getFirst(K key) {
        List values = (List)this.get(key);
        return values != null ? (V)values.get(0) : null;
    }

    @Override
    public void set(K key, V value) {
        LinkedList<V> values = new LinkedList<V>();
        values.add(value);
        this.put(key, values);
    }

    @Override
    public void setAll(Map<K, V> values) {
        values.forEach(this::set);
    }

    @Override
    public void put(K key, V[] values) {
        LinkedList list = new LinkedList();
        if (values != null) {
            Collections.addAll(list, values);
        }
        this.put(key, list);
    }

    @Override
    public Map<K, V> toSingleValueMap() {
        LinkedHashMap singleValueMap = new LinkedHashMap(this.size());
        this.forEach((key, value) -> singleValueMap.put(key, value.get(0)));
        return singleValueMap;
    }

    @Override
    public LinkedMultiValueMap<K, V> clone() {
        return new LinkedMultiValueMap<K, V>(this);
    }

    public LinkedMultiValueMap<K, V> deepCopy() {
        LinkedMultiValueMap copy = new LinkedMultiValueMap(this.size());
        this.forEach((key, value) -> copy.put(key, new LinkedList(value)));
        return copy;
    }
}

