/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.StringUtils;

public class PrefixSuffixPattern {
    public static final char PREFIX_SUFFIX_PATTERN_SEPARATOR = '*';
    private String prefix;
    private String suffix;
    private boolean splitted;

    public PrefixSuffixPattern() {
    }

    public PrefixSuffixPattern(String input) {
        this.split(input);
    }

    public boolean split(String input) {
        int start;
        int n = start = input != null ? input.indexOf(42) : -1;
        if (start == -1) {
            this.prefix = null;
            this.suffix = null;
            this.splitted = false;
        } else {
            this.prefix = start > 0 ? input.substring(0, start) : null;
            this.suffix = start < input.length() - 1 ? input.substring(start + 1) : null;
            this.splitted = this.prefix != null || this.suffix != null || input.length() == 1 && input.charAt(0) == '*';
        }
        return this.splitted;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isSplitted() {
        return this.splitted;
    }

    public String join(String input) {
        return PrefixSuffixPattern.join(this.prefix, input, this.suffix);
    }

    public static String join(String prefix, String input, String suffix) {
        if (prefix != null && suffix != null) {
            return prefix + StringUtils.nullToEmpty(input) + suffix;
        }
        if (prefix != null) {
            return prefix + StringUtils.nullToEmpty(input);
        }
        if (suffix != null) {
            return StringUtils.nullToEmpty(input) + suffix;
        }
        return input;
    }

    public static PrefixSuffixPattern parse(String input) {
        PrefixSuffixPattern pattern;
        if (input != null && !input.isEmpty() && (pattern = new PrefixSuffixPattern(input)).isSplitted()) {
            return pattern;
        }
        return null;
    }
}

