/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.ConcurrentReferenceHashMap;
import com.aspectran.core.util.PBEncryptionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public class PropertiesLoaderUtils {
    private static final String XML_FILE_EXTENSION = ".xml";
    private static final String ENCRYPTED_RESOURCE_NAME_SUFFIX = "encrypted.properties";
    private static final Map<String, Properties> cache = new ConcurrentReferenceHashMap<String, Properties>();

    public static Properties loadProperties(String resourceName) throws IOException {
        return PropertiesLoaderUtils.loadProperties(resourceName, ClassUtils.getDefaultClassLoader());
    }

    public static Properties loadProperties(String resourceName, ClassLoader classLoader) throws IOException {
        Properties props = cache.get(resourceName);
        if (props == null) {
            props = new Properties();
            PropertiesLoaderUtils.fillProperties(props, resourceName, classLoader);
            Properties existing = cache.putIfAbsent(resourceName, props);
            if (existing != null) {
                props = existing;
            }
        }
        return props;
    }

    public static void fillProperties(Properties props, String resourceName) throws IOException {
        PropertiesLoaderUtils.fillProperties(props, resourceName, ClassUtils.getDefaultClassLoader());
    }

    public static void fillProperties(Properties props, String resourceName, ClassLoader classLoader) throws IOException {
        Enumeration<URL> urls = classLoader.getResources(resourceName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URLConnection con = url.openConnection();
            InputStream is = con.getInputStream();
            try {
                if (resourceName.endsWith(XML_FILE_EXTENSION)) {
                    props.loadFromXML(is);
                    continue;
                }
                props.load(is);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        if (resourceName.endsWith(ENCRYPTED_RESOURCE_NAME_SUFFIX)) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String value;
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (!(val instanceof String) || !PropertyValueEncryptionUtils.isEncryptedValue((String)(value = (String)val))) continue;
                value = PropertyValueEncryptionUtils.decrypt((String)value, (StringEncryptor)PBEncryptionUtils.getEncryptor());
                props.put(key, value);
            }
        }
    }
}

