/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.ExceptionUtils;
import com.aspectran.core.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static Object getField(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access field: " + field, e);
        }
    }

    public static void setField(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access field: " + field, e);
        }
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Could not access method: " + method, ExceptionUtils.getRootCause(e));
        }
    }

    public static float getTypeDifferenceWeight(Class<?>[] paramTypes, Object[] destArgs) {
        Object destArg;
        Class<?> srcClass;
        if (paramTypes.length != destArgs.length) {
            return Float.MAX_VALUE;
        }
        float weight = 0.0f;
        for (int i = 0; i < paramTypes.length && (weight += ReflectionUtils.getTypeDifferenceWeight(srcClass = paramTypes[i], destArg = destArgs[i])) != Float.MAX_VALUE; ++i) {
        }
        return weight;
    }

    public static float getTypeDifferenceWeight(Class<?> paramType, Object destArg) {
        if (!TypeUtils.isAssignableValue(paramType, destArg)) {
            return Float.MAX_VALUE;
        }
        return ReflectionUtils.getTypeDifferenceWeight(paramType, destArg != null ? destArg.getClass() : null);
    }

    public static float getTypeDifferenceWeight(Class<?>[] srcArgs, Class<?>[] destArgs) {
        Class<?> destClass;
        Class<?> srcClass;
        float weight = 0.0f;
        for (int i = 0; i < srcArgs.length && (weight += ReflectionUtils.getTypeDifferenceWeight(srcClass = srcArgs[i], destClass = destArgs[i])) != Float.MAX_VALUE; ++i) {
        }
        return weight;
    }

    public static float getTypeDifferenceWeight(Class<?> srcClass, Class<?> destClass) {
        if (srcClass == null) {
            return Float.MAX_VALUE;
        }
        if (destClass != null) {
            if (srcClass.isArray() && destClass.isArray()) {
                srcClass = srcClass.getComponentType();
                destClass = destClass.getComponentType();
            }
            if (destClass.isPrimitive() && srcClass.equals(TypeUtils.getPrimitiveWrapper(destClass)) || srcClass.isPrimitive() && destClass.equals(TypeUtils.getPrimitiveWrapper(srcClass))) {
                return 0.1f;
            }
        }
        float weight = 0.0f;
        while (destClass != null) {
            if (destClass.equals(srcClass)) {
                if (!destClass.isInterface()) break;
                weight += 0.25f;
                break;
            }
            weight += 1.0f;
            destClass = destClass.getSuperclass();
        }
        if (destClass == null) {
            weight += 1.5f;
        }
        return weight;
    }

    public static Object toPrimitiveArray(Object val) {
        if (val instanceof Boolean[]) {
            int len = Array.getLength(val);
            boolean[] arr = new boolean[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = (Boolean)Array.get(val, i);
            }
            return arr;
        }
        if (val instanceof Byte[]) {
            int len = Array.getLength(val);
            byte[] arr = new byte[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = (Byte)Array.get(val, i);
            }
            return arr;
        }
        if (val instanceof Character[]) {
            int len = Array.getLength(val);
            char[] arr = new char[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = ((Character)Array.get(val, i)).charValue();
            }
            return arr;
        }
        if (val instanceof Short[]) {
            int len = Array.getLength(val);
            short[] arr = new short[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = (Short)Array.get(val, i);
            }
            return arr;
        }
        if (val instanceof Integer[]) {
            int len = Array.getLength(val);
            int[] arr = new int[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = (Integer)Array.get(val, i);
            }
            return arr;
        }
        if (val instanceof Long[]) {
            int len = Array.getLength(val);
            long[] arr = new long[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = (Long)Array.get(val, i);
            }
            return arr;
        }
        if (val instanceof Float[]) {
            int len = Array.getLength(val);
            float[] arr = new float[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = ((Float)Array.get(val, i)).floatValue();
            }
            return arr;
        }
        if (val instanceof Double[]) {
            int len = Array.getLength(val);
            double[] arr = new double[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = (Double)Array.get(val, i);
            }
            return arr;
        }
        return null;
    }

    public static Object toComponentTypeArray(Object val, Class<?> componentType) {
        if (val != null) {
            int len = Array.getLength(val);
            Object arr = Array.newInstance(componentType, len);
            for (int i = 0; i < len; ++i) {
                Array.set(arr, i, Array.get(val, i));
            }
            return arr;
        }
        return null;
    }
}

