/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.apon.AponReader;
import com.aspectran.core.util.apon.AponWriter;
import com.aspectran.core.util.apon.Parameter;
import com.aspectran.core.util.apon.ParameterKey;
import com.aspectran.core.util.apon.ParameterValue;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.apon.UnknownParameterException;
import com.aspectran.core.util.apon.ValueType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractParameters
implements Parameters {
    private final Map<String, ParameterValue> parameterValueMap;
    private final Map<String, ParameterValue> altParameterValueMap;
    private final boolean structureFixed;
    private Parameter proprietor;
    private String actualName;

    protected AbstractParameters(ParameterKey[] parameterKeys) {
        LinkedHashMap<String, ParameterValue> valueMap = new LinkedHashMap<String, ParameterValue>();
        if (parameterKeys != null) {
            HashMap<String, ParameterValue> altValueMap = new HashMap<String, ParameterValue>();
            for (ParameterKey pk : parameterKeys) {
                ParameterValue pv = pk.newParameterValue();
                pv.setContainer(this);
                valueMap.put(pk.getName(), pv);
                if (pk.getAltNames() == null) continue;
                for (String altName : pk.getAltNames()) {
                    altValueMap.put(altName, pv);
                }
            }
            this.parameterValueMap = Collections.unmodifiableMap(valueMap);
            this.altParameterValueMap = altValueMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(altValueMap);
            this.structureFixed = true;
        } else {
            this.parameterValueMap = valueMap;
            this.altParameterValueMap = Collections.emptyMap();
            this.structureFixed = false;
        }
    }

    @Override
    public boolean isStructureFixed() {
        return this.structureFixed;
    }

    @Override
    public Parameter getProprietor() {
        return this.proprietor;
    }

    @Override
    public void setProprietor(Parameter proprietor) {
        this.proprietor = proprietor;
    }

    @Override
    public Parameter getParent() {
        if (this.proprietor != null && this.proprietor.getContainer() != null) {
            return this.proprietor.getContainer().getProprietor();
        }
        return null;
    }

    @Override
    public String getActualName() {
        if (this.proprietor == null) {
            return this.actualName;
        }
        return this.actualName != null ? this.actualName : this.proprietor.getName();
    }

    @Override
    public void setActualName(String actualName) {
        this.actualName = actualName;
    }

    @Override
    public String getQualifiedName() {
        if (this.proprietor != null) {
            return this.proprietor.getQualifiedName();
        }
        return this.getClass().getName();
    }

    @Override
    public ParameterValue getParameterValue(String name) {
        ParameterValue pv = this.parameterValueMap.get(name);
        if (pv != null) {
            return pv;
        }
        if (this.altParameterValueMap != null) {
            return this.altParameterValueMap.get(name);
        }
        return null;
    }

    @Override
    public Map<String, ParameterValue> getParameterValueMap() {
        return this.parameterValueMap;
    }

    @Override
    public String[] getParameterNames() {
        return this.parameterValueMap.keySet().toArray(new String[0]);
    }

    @Override
    public Set<String> getParameterNameSet() {
        return this.parameterValueMap.keySet();
    }

    @Override
    public boolean hasParameter(String name) {
        return this.parameterValueMap.containsKey(name) || this.altParameterValueMap != null && this.altParameterValueMap.containsKey(name);
    }

    @Override
    public boolean hasParameter(ParameterKey parameterKey) {
        return this.hasParameter(parameterKey.getName());
    }

    @Override
    public boolean isAssigned(String name) {
        ParameterValue p = this.getParameterValue(name);
        return p != null && p.isAssigned();
    }

    @Override
    public boolean isAssigned(ParameterKey parameterKey) {
        return this.isAssigned(parameterKey.getName());
    }

    @Override
    public boolean hasValue(String name) {
        ParameterValue p = this.getParameterValue(name);
        return p != null && p.hasValue();
    }

    @Override
    public boolean hasValue(ParameterKey parameterKey) {
        ParameterValue p = this.getParameterValue(parameterKey.getName());
        return p != null && p.hasValue();
    }

    @Override
    public Parameter getParameter(String name) {
        ParameterValue p = this.getParameterValue(name);
        if (p == null && this.structureFixed) {
            throw new UnknownParameterException(name, this);
        }
        return p;
    }

    @Override
    public Parameter getParameter(ParameterKey parameterKey) {
        return this.getParameter(parameterKey.getName());
    }

    @Override
    public Object getValue(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValue() : null;
    }

    @Override
    public Object getValue(ParameterKey parameterKey) {
        return this.getValue(parameterKey.getName());
    }

    @Override
    public void putAll(Parameters parameters) {
        if (this.structureFixed) {
            throw new IllegalStateException();
        }
        for (ParameterValue parameterValue : parameters.getParameterValueMap().values()) {
            parameterValue.setContainer(this);
        }
        this.parameterValueMap.putAll(parameters.getParameterValueMap());
    }

    @Override
    public void putValue(String name, Object value) {
        Parameter p = this.getParameter(name);
        if (p == null) {
            p = this.newParameterValue(name, ValueType.determineValueType(value));
        }
        p.putValue(value);
        if (value instanceof Parameters) {
            ((Parameters)value).setActualName(name);
            ((Parameters)value).updateContainer(this);
        }
    }

    @Override
    public void putValue(ParameterKey parameterKey, Object value) {
        this.putValue(parameterKey.getName(), value);
    }

    @Override
    public void putValueNonNull(String name, Object value) {
        if (value != null) {
            this.putValue(name, value);
        }
    }

    @Override
    public void putValueNonNull(ParameterKey parameterKey, Object value) {
        if (value != null) {
            this.putValue(parameterKey.getName(), value);
        }
    }

    @Override
    public void clearValue(String name) {
        if (this.structureFixed) {
            Parameter p = this.getParameter(name);
            if (p != null) {
                p.clearValue();
            }
        } else {
            this.parameterValueMap.remove(name);
        }
    }

    @Override
    public void clearValue(ParameterKey parameterKey) {
        this.clearValue(parameterKey.getName());
    }

    @Override
    public String getString(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsString() : null;
    }

    @Override
    public String getString(String name, String defaultValue) {
        String s = this.getString(name);
        return s != null ? s : defaultValue;
    }

    @Override
    public String getString(ParameterKey parameterKey) {
        return this.getString(parameterKey.getName());
    }

    @Override
    public String getString(ParameterKey parameterKey, String defaultValue) {
        return this.getString(parameterKey.getName(), defaultValue);
    }

    @Override
    public String[] getStringArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsStringArray() : null;
    }

    @Override
    public String[] getStringArray(ParameterKey parameterKey) {
        return this.getStringArray(parameterKey.getName());
    }

    @Override
    public List<String> getStringList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsStringList() : null;
    }

    @Override
    public List<String> getStringList(ParameterKey parameterKey) {
        return this.getStringList(parameterKey.getName());
    }

    @Override
    public Integer getInt(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsInt() : null;
    }

    @Override
    public int getInt(String name, int defaultValue) {
        Parameter p = this.getParameter(name);
        if (p != null) {
            Integer val = p.getValueAsInt();
            return val != null ? val : defaultValue;
        }
        return defaultValue;
    }

    @Override
    public Integer[] getIntArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsIntArray() : null;
    }

    @Override
    public Integer getInt(ParameterKey parameterKey) {
        return this.getInt(parameterKey.getName());
    }

    @Override
    public int getInt(ParameterKey parameterKey, int defaultValue) {
        return this.getInt(parameterKey.getName(), defaultValue);
    }

    @Override
    public Integer[] getIntArray(ParameterKey parameterKey) {
        return this.getIntArray(parameterKey.getName());
    }

    @Override
    public List<Integer> getIntList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsIntList() : null;
    }

    @Override
    public List<Integer> getIntList(ParameterKey parameterKey) {
        return this.getIntList(parameterKey.getName());
    }

    @Override
    public Long getLong(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsLong() : null;
    }

    @Override
    public long getLong(String name, long defaultValue) {
        Parameter p = this.getParameter(name);
        if (p != null) {
            Long val = p.getValueAsLong();
            return val != null ? val : defaultValue;
        }
        return defaultValue;
    }

    @Override
    public Long getLong(ParameterKey parameterKey) {
        return this.getLong(parameterKey.getName());
    }

    @Override
    public long getLong(ParameterKey parameterKey, long defaultValue) {
        return this.getLong(parameterKey.getName(), defaultValue);
    }

    @Override
    public Long[] getLongArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsLongArray() : null;
    }

    @Override
    public Long[] getLongArray(ParameterKey parameterKey) {
        return this.getLongArray(parameterKey.getName());
    }

    @Override
    public List<Long> getLongList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsLongList() : null;
    }

    @Override
    public List<Long> getLongList(ParameterKey parameterKey) {
        return this.getLongList(parameterKey.getName());
    }

    @Override
    public Float getFloat(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsFloat() : null;
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        Parameter p = this.getParameter(name);
        if (p != null) {
            Float val = p.getValueAsFloat();
            return val != null ? val.floatValue() : defaultValue;
        }
        return defaultValue;
    }

    @Override
    public Float getFloat(ParameterKey parameterKey) {
        return this.getFloat(parameterKey.getName());
    }

    @Override
    public float getFloat(ParameterKey parameterKey, float defaultValue) {
        return this.getFloat(parameterKey.getName(), defaultValue);
    }

    @Override
    public Float[] getFloatArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsFloatArray() : null;
    }

    @Override
    public Float[] getFloatArray(ParameterKey parameterKey) {
        return this.getFloatArray(parameterKey.getName());
    }

    @Override
    public List<Float> getFloatList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsFloatList() : null;
    }

    @Override
    public List<Float> getFloatList(ParameterKey parameterKey) {
        return this.getFloatList(parameterKey.getName());
    }

    @Override
    public Double getDouble(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsDouble() : null;
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        Parameter p = this.getParameter(name);
        if (p != null) {
            Double val = p.getValueAsDouble();
            return val != null ? val : defaultValue;
        }
        return defaultValue;
    }

    @Override
    public Double getDouble(ParameterKey parameterKey) {
        return this.getDouble(parameterKey.getName());
    }

    @Override
    public double getDouble(ParameterKey parameterKey, double defaultValue) {
        return this.getDouble(parameterKey.getName(), defaultValue);
    }

    @Override
    public Double[] getDoubleArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsDoubleArray() : null;
    }

    @Override
    public Double[] getDoubleArray(ParameterKey parameterKey) {
        return this.getDoubleArray(parameterKey.getName());
    }

    @Override
    public List<Double> getDoubleList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsDoubleList() : null;
    }

    @Override
    public List<Double> getDoubleList(ParameterKey parameterKey) {
        return this.getDoubleList(parameterKey.getName());
    }

    @Override
    public Boolean getBoolean(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsBoolean() : null;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        Parameter p = this.getParameter(name);
        return p != null ? BooleanUtils.toBoolean(p.getValueAsBoolean(), defaultValue) : defaultValue;
    }

    @Override
    public Boolean getBoolean(ParameterKey parameterKey) {
        return this.getBoolean(parameterKey.getName());
    }

    @Override
    public boolean getBoolean(ParameterKey parameterKey, boolean defaultValue) {
        return this.getBoolean(parameterKey.getName(), defaultValue);
    }

    @Override
    public Boolean[] getBooleanArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsBooleanArray() : null;
    }

    @Override
    public Boolean[] getBooleanArray(ParameterKey parameterKey) {
        return this.getBooleanArray(parameterKey.getName());
    }

    @Override
    public List<Boolean> getBooleanList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsBooleanList() : null;
    }

    @Override
    public List<Boolean> getBooleanList(ParameterKey parameterKey) {
        return this.getBooleanList(parameterKey.getName());
    }

    @Override
    public <T extends Parameters> T getParameters(String name) {
        Parameter p = this.getParameter(name);
        return (T)(p != null ? (Parameters)p.getValue() : null);
    }

    @Override
    public <T extends Parameters> T getParameters(ParameterKey parameterKey) {
        return this.getParameters(parameterKey.getName());
    }

    @Override
    public <T extends Parameters> T[] getParametersArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsParametersArray() : null;
    }

    @Override
    public <T extends Parameters> T[] getParametersArray(ParameterKey parameterKey) {
        return this.getParametersArray(parameterKey.getName());
    }

    @Override
    public <T extends Parameters> List<T> getParametersList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsParametersList() : null;
    }

    @Override
    public <T extends Parameters> List<T> getParametersList(ParameterKey parameterKey) {
        return this.getParametersList(parameterKey.getName());
    }

    @Override
    public ParameterValue newParameterValue(String name, ValueType valueType) {
        return this.newParameterValue(name, valueType, false);
    }

    @Override
    public ParameterValue newParameterValue(String name, ValueType valueType, boolean array) {
        if (this.structureFixed) {
            throw new IllegalStateException();
        }
        ParameterValue pv = new ParameterValue(name, valueType, array);
        pv.setContainer(this);
        this.parameterValueMap.put(name, pv);
        return pv;
    }

    @Override
    public <T extends Parameters> T newParameters(String name) {
        Parameter p = this.getParameter(name);
        if (this.structureFixed) {
            if (p == null) {
                throw new UnknownParameterException(name, this);
            }
        } else if (p == null) {
            p = this.newParameterValue(name, ValueType.PARAMETERS);
        }
        Object ps = p.newParameters(p);
        ps.setActualName(name);
        return ps;
    }

    @Override
    public <T extends Parameters> T newParameters(ParameterKey parameterKey) {
        return this.newParameters(parameterKey.getName());
    }

    @Override
    public <T extends Parameters> T touchParameters(String name) {
        T parameters = this.getParameters(name);
        if (parameters == null) {
            parameters = this.newParameters(name);
        }
        return parameters;
    }

    @Override
    public <T extends Parameters> T touchParameters(ParameterKey parameterKey) {
        return this.touchParameters(parameterKey.getName());
    }

    @Override
    public void updateContainer(Parameters container) {
        for (ParameterValue parameterValue : container.getParameterValueMap().values()) {
            parameterValue.setContainer(container);
        }
    }

    @Override
    public void readFrom(String apon) throws IOException {
        if (apon != null) {
            AponReader.parse(apon, this);
        }
    }

    @Override
    public String describe() {
        return this.describe(false);
    }

    @Override
    public String describe(boolean details) {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("qualifiedName", this.getQualifiedName());
        if (details) {
            tsb.append("parameters", this.parameterValueMap);
        } else {
            tsb.append("parameters", this.getParameterNames());
        }
        tsb.append("class", this.getClass().getName());
        tsb.append("parent", this.getParent());
        return tsb.toString();
    }

    public String toString() {
        try {
            return ((AponWriter)((AponWriter)new AponWriter().nullWritable(false)).write(this)).toString();
        }
        catch (IOException e) {
            return "";
        }
    }
}

