/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.lang.NonNull;
import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.apon.AbstractParameters;
import com.aspectran.core.util.apon.InvalidParameterValueException;
import com.aspectran.core.util.apon.Parameter;
import com.aspectran.core.util.apon.ParameterKey;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.apon.UnknownParameterException;
import com.aspectran.core.util.apon.VariableParameters;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ArrayParameters
extends AbstractParameters
implements Iterable<Parameters>,
Serializable {
    private static final long serialVersionUID = 2058392199376865356L;
    public static final String NONAME = "<noname>";
    private final Class<? extends AbstractParameters> elementClass;

    public ArrayParameters() {
        this(VariableParameters.class);
    }

    public ArrayParameters(String text) throws IOException {
        this(VariableParameters.class, text);
    }

    public ArrayParameters(Class<? extends AbstractParameters> elementClass) {
        super(ArrayParameters.createParameterKeys(elementClass));
        this.elementClass = elementClass;
    }

    public ArrayParameters(Class<? extends AbstractParameters> elementClass, String text) throws IOException {
        this(elementClass);
        this.readFrom(StringUtils.trimWhitespace(text));
    }

    public void addParameters(Parameters parameters) {
        this.putValue(NONAME, (Object)parameters);
    }

    public <T extends Parameters> T[] getParametersArray() {
        return this.getParametersArray(NONAME);
    }

    public <T extends Parameters> List<T> getParametersList() {
        return this.getParametersList(NONAME);
    }

    @Override
    @NonNull
    public Iterator<Parameters> iterator() {
        List list = this.getParametersList(NONAME);
        if (list != null) {
            return list.iterator();
        }
        return Collections.emptyIterator();
    }

    @Override
    public <T extends Parameters> T newParameters(String name) {
        Parameter p = this.getParameter(name);
        if (p == null) {
            throw new UnknownParameterException(name, this);
        }
        try {
            Parameters sub = ClassUtils.createInstance(this.elementClass);
            sub.setProprietor(p);
            p.putValue(sub);
            return (T)sub;
        }
        catch (Exception e) {
            throw new InvalidParameterValueException("Failed to instantiate " + this.elementClass, e);
        }
    }

    private static ParameterKey[] createParameterKeys(Class<? extends AbstractParameters> elementClass) {
        ParameterKey pk = new ParameterKey(NONAME, elementClass, true);
        return new ParameterKey[]{pk};
    }
}

