/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.apon.ArrayParameters;
import com.aspectran.core.util.apon.Parameter;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.apon.ValueType;
import com.aspectran.core.util.apon.VariableParameters;
import com.aspectran.core.util.json.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class JsonToApon {
    public static Parameters from(String json) throws IOException {
        return JsonToApon.from(json, new VariableParameters());
    }

    public static <T extends Parameters> T from(String json, Class<T> requiredType) throws IOException {
        Parameters container = (Parameters)ClassUtils.createInstance(requiredType);
        JsonToApon.from(json, container);
        return (T)container;
    }

    public static <T extends Parameters> T from(String json, T container) throws IOException {
        if (json == null) {
            throw new IllegalArgumentException("json must not be null");
        }
        return JsonToApon.from((Reader)new StringReader(json), container);
    }

    public static Parameters from(Reader in) throws IOException {
        return JsonToApon.from(in, new VariableParameters());
    }

    public static <T extends Parameters> T from(Reader in, Class<T> requiredType) throws IOException {
        Parameters container = (Parameters)ClassUtils.createInstance(requiredType);
        JsonToApon.from(in, container);
        return (T)container;
    }

    public static <T extends Parameters> T from(Reader in, T container) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("in must not be null");
        }
        if (container == null) {
            throw new IllegalArgumentException("container must not be null");
        }
        try {
            JsonReader reader = new JsonReader(in);
            String name = container instanceof ArrayParameters ? "<noname>" : null;
            JsonToApon.convert(reader, container, name);
        }
        catch (Exception e) {
            throw new IOException("Failed to convert XML to JSON", e);
        }
        return container;
    }

    private static void convert(JsonReader reader, Parameters container, String name) throws IOException {
        switch (reader.peek()) {
            case BEGIN_OBJECT: {
                reader.beginObject();
                if (name != null) {
                    container = container.newParameters(name);
                }
                while (reader.hasNext()) {
                    JsonToApon.convert(reader, container, reader.nextName());
                }
                reader.endObject();
                return;
            }
            case BEGIN_ARRAY: {
                reader.beginArray();
                while (reader.hasNext()) {
                    JsonToApon.convert(reader, container, name);
                }
                reader.endArray();
                return;
            }
            case STRING: {
                container.putValue(name, (Object)reader.nextString());
                return;
            }
            case BOOLEAN: {
                container.putValue(name, (Object)reader.nextBoolean());
                return;
            }
            case NUMBER: {
                try {
                    container.putValue(name, (Object)reader.nextInt());
                }
                catch (NumberFormatException e0) {
                    try {
                        container.putValue(name, (Object)reader.nextLong());
                    }
                    catch (NumberFormatException e1) {
                        container.putValue(name, (Object)reader.nextDouble());
                    }
                }
                return;
            }
            case NULL: {
                reader.nextNull();
                Parameter parameter = container.getParameter(name);
                if (parameter == null || parameter.getValueType() != ValueType.PARAMETERS) {
                    container.putValue(name, null);
                }
                return;
            }
        }
        throw new IllegalStateException();
    }
}

