/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.apon;

import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.apon.Parameter;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.apon.ValueType;
import com.aspectran.core.util.apon.VariableParameters;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToApon {
    public static Parameters from(String xml) throws IOException {
        return XmlToApon.from(xml, new VariableParameters());
    }

    public static <T extends Parameters> T from(String xml, Class<T> requiredType) throws IOException {
        Parameters container = (Parameters)ClassUtils.createInstance(requiredType);
        XmlToApon.from(xml, container);
        return (T)container;
    }

    public static <T extends Parameters> T from(String xml, T container) throws IOException {
        if (xml == null) {
            throw new IllegalArgumentException("xml must not be null");
        }
        return XmlToApon.from((Reader)new StringReader(xml), container);
    }

    public static Parameters from(Reader in) throws IOException {
        return XmlToApon.from(in, new VariableParameters());
    }

    public static <T extends Parameters> T from(Reader in, Class<T> requiredType) throws IOException {
        Parameters container = (Parameters)ClassUtils.createInstance(requiredType);
        XmlToApon.from(in, container);
        return (T)container;
    }

    public static <T extends Parameters> T from(Reader in, T container) throws IOException {
        return XmlToApon.from(new InputSource(in), container);
    }

    public static Parameters from(InputStream in) throws IOException {
        return XmlToApon.from(in, new VariableParameters());
    }

    public static <T extends Parameters> T from(InputStream in, Class<T> requiredType) throws IOException {
        Parameters container = (Parameters)ClassUtils.createInstance(requiredType);
        XmlToApon.from(in, container);
        return (T)container;
    }

    public static <T extends Parameters> T from(InputStream in, T container) throws IOException {
        return XmlToApon.from(new InputSource(in), container);
    }

    public static Parameters from(File file) throws IOException {
        return XmlToApon.from(new InputSource(file.toURI().toASCIIString()), new VariableParameters());
    }

    public static <T extends Parameters> T from(File file, Class<T> requiredType) throws IOException {
        Parameters container = (Parameters)ClassUtils.createInstance(requiredType);
        XmlToApon.from(file, container);
        return (T)container;
    }

    public static <T extends Parameters> T from(File file, T container) throws IOException {
        return XmlToApon.from(new InputSource(file.toURI().toASCIIString()), container);
    }

    public static <T extends Parameters> T from(InputSource is, T container) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputSource must not be null");
        }
        if (container == null) {
            throw new IllegalArgumentException("container must not be null");
        }
        ParameterValueHandler valueHandler = null;
        try {
            valueHandler = new ParameterValueHandler(container);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(is, (DefaultHandler)valueHandler);
        }
        catch (Exception e) {
            String location;
            if (valueHandler != null && valueHandler.getLocator() != null) {
                Locator locator = valueHandler.getLocator();
                location = "Line Number " + locator.getLineNumber() + ", Column " + locator.getColumnNumber();
                location = locator.getSystemId() != null ? "; " + locator.getSystemId() + " " + location : "; " + location;
            } else {
                location = "";
            }
            throw new IOException("Failed to convert XML to APON" + location + "; " + e.getMessage(), e);
        }
        return container;
    }

    private static class ParameterValueHandler
    extends DefaultHandler {
        private final StringBuilder buffer = new StringBuilder();
        private Parameters parameters;
        private String name;
        private boolean open;
        private boolean leaf;
        private Locator locator;

        public ParameterValueHandler(Parameters container) {
            this.parameters = container;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.name != null) {
                this.parameters = this.parameters.newParameters(this.name);
                this.leaf = false;
            }
            Parameter p = this.parameters.getParameter(qName);
            if (attributes != null && attributes.getLength() > 0 || p != null && p.getValueType() == ValueType.PARAMETERS) {
                this.parameters = this.parameters.newParameters(qName);
                if (attributes != null) {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.parameters.putValue(attributes.getQName(i), (Object)attributes.getValue(i));
                    }
                }
                this.name = null;
                this.leaf = false;
            } else {
                this.name = qName;
                this.leaf = true;
            }
            this.open = true;
            if (this.buffer.length() > 0) {
                this.buffer.delete(0, this.buffer.length());
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.open) {
                String text = null;
                if (this.buffer.length() > 0) {
                    text = this.buffer.toString();
                    this.buffer.delete(0, this.buffer.length());
                }
                if (text != null) {
                    this.parameters.putValue(qName, (Object)text);
                }
                this.name = null;
                this.open = false;
            }
            if (!this.leaf) {
                this.parameters = this.parameters.getProprietor().getContainer();
            } else {
                this.leaf = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        public Locator getLocator() {
            return this.locator;
        }
    }
}

