/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.json;

import com.aspectran.core.util.ArrayStack;
import com.aspectran.core.util.BeanUtils;
import com.aspectran.core.util.apon.Parameter;
import com.aspectran.core.util.apon.ParameterValue;
import com.aspectran.core.util.apon.Parameters;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class JsonWriter
implements Flushable,
Closeable {
    private static final String DEFAULT_INDENT_STRING = "  ";
    private final ArrayStack<Boolean> writtenFlags = new ArrayStack();
    private final Writer out;
    private boolean prettyPrint;
    private String indentString;
    private String dateFormat;
    private String dateTimeFormat;
    private boolean skipNull;
    private int indentDepth;
    private String pendedName;

    public JsonWriter() {
        this(new StringWriter());
    }

    public JsonWriter(Writer out) {
        this.out = out;
        this.setIndentString(DEFAULT_INDENT_STRING);
        this.writtenFlags.push(false);
    }

    private void setIndentString(String indentString) {
        this.prettyPrint = indentString != null;
        this.indentString = indentString;
    }

    public <T extends JsonWriter> T prettyPrint(boolean prettyPrint) {
        if (prettyPrint) {
            this.setIndentString(DEFAULT_INDENT_STRING);
        } else {
            this.setIndentString(null);
        }
        return (T)this;
    }

    public <T extends JsonWriter> T indentString(String indentString) {
        this.setIndentString(indentString);
        return (T)this;
    }

    public <T extends JsonWriter> T dateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return (T)this;
    }

    public <T extends JsonWriter> T dateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
        return (T)this;
    }

    public <T extends JsonWriter> T nullWritable(boolean nullWritable) {
        this.skipNull = !nullWritable;
        return (T)this;
    }

    public <T extends JsonWriter> T write(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
        } else if (object instanceof String) {
            this.writeValue(object.toString());
        } else if (object instanceof Character) {
            this.writeValue(String.valueOf(((Character)object).charValue()));
        } else if (object instanceof Boolean) {
            this.writeValue((Boolean)object);
        } else if (object instanceof Number) {
            this.writeValue((Number)object);
        } else if (object instanceof Parameters) {
            this.beginObject();
            Map<String, ParameterValue> params = ((Parameters)object).getParameterValueMap();
            for (Parameter parameter : params.values()) {
                String name = parameter.getName();
                Object value = parameter.getValue();
                this.checkCircularReference(object, value);
                this.writeName(name);
                this.write(value);
            }
            this.endObject();
        } else if (object instanceof Map) {
            this.beginObject();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                String string = entry.getKey().toString();
                Object value = entry.getValue();
                this.checkCircularReference(object, value);
                this.writeName(string);
                this.write(value);
            }
            this.endObject();
        } else if (object instanceof Collection) {
            this.beginArray();
            for (Object value : (Collection)object) {
                this.checkCircularReference(object, value);
                if (value != null) {
                    this.write(value);
                    continue;
                }
                this.writeNull(true);
            }
            this.endArray();
        } else if (object.getClass().isArray()) {
            this.beginArray();
            int len = Array.getLength(object);
            for (int i = 0; i < len; ++i) {
                Object object2 = Array.get(object, i);
                this.checkCircularReference(object, object2);
                if (object2 != null) {
                    this.write(object2);
                    continue;
                }
                this.writeNull(true);
            }
            this.endArray();
        } else if (object instanceof Date) {
            if (this.dateTimeFormat != null) {
                SimpleDateFormat dt = new SimpleDateFormat(this.dateTimeFormat);
                this.writeValue(dt.format((Date)object));
            } else {
                this.writeValue(object.toString());
            }
        } else if (object instanceof LocalDate) {
            if (this.dateFormat != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.dateFormat);
                this.writeValue(((LocalDate)object).format(formatter));
            } else {
                this.writeValue(object.toString());
            }
        } else if (object instanceof LocalDateTime) {
            if (this.dateTimeFormat != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.dateTimeFormat);
                this.writeValue(((LocalDateTime)object).format(formatter));
            } else {
                this.writeValue(object.toString());
            }
        } else {
            String[] readablePropertyNames = BeanUtils.getReadablePropertyNamesWithoutNonSerializable(object);
            if (readablePropertyNames != null && readablePropertyNames.length > 0) {
                this.beginObject();
                for (String propertyName : readablePropertyNames) {
                    Object value;
                    try {
                        value = BeanUtils.getProperty(object, propertyName);
                    }
                    catch (InvocationTargetException e) {
                        throw new IOException(e);
                    }
                    this.checkCircularReference(object, value);
                    this.writeName(propertyName);
                    this.write(value);
                }
                this.endObject();
            } else {
                this.writeValue(object.toString());
            }
        }
        return (T)this;
    }

    public void writeName(String name) {
        this.pendedName = name;
    }

    private void writePendedName() throws IOException {
        if (this.writtenFlags.peek().booleanValue()) {
            this.writeComma();
        }
        if (this.pendedName != null) {
            this.indent();
            this.out.write(JsonWriter.escape(this.pendedName));
            this.out.write(":");
            if (this.prettyPrint) {
                this.out.write(" ");
            }
            this.pendedName = null;
        } else {
            this.indent();
        }
    }

    public void writeValue(String value) throws IOException {
        if (!this.skipNull || value != null) {
            this.writePendedName();
            this.out.write(JsonWriter.escape(value));
            this.writtenFlags.update(true);
        }
    }

    public void writeValue(Boolean value) throws IOException {
        if (!this.skipNull || value != null) {
            this.writePendedName();
            this.out.write(value.toString());
            this.writtenFlags.update(true);
        }
    }

    public void writeValue(Number value) throws IOException {
        if (!this.skipNull || value != null) {
            this.writePendedName();
            this.out.write(value.toString());
            this.writtenFlags.update(true);
        }
    }

    public void writeNull() throws IOException {
        this.writeNull(false);
    }

    public void writeNull(boolean force) throws IOException {
        if (!this.skipNull || force) {
            this.writePendedName();
            this.out.write("null");
            this.writtenFlags.update(true);
        }
    }

    public void writeJson(String json) throws IOException {
        if (!this.skipNull || json != null) {
            String line;
            this.writePendedName();
            BufferedReader reader = new BufferedReader(new StringReader(json));
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (!first) {
                    this.nextLine();
                    this.indent();
                }
                this.out.write(line);
                first = false;
            }
            this.writtenFlags.update(true);
        }
    }

    private void writeComma() throws IOException {
        this.out.write(",");
        this.nextLine();
    }

    public void beginObject() throws IOException {
        this.writePendedName();
        this.out.write("{");
        this.nextLine();
        ++this.indentDepth;
        this.writtenFlags.push(false);
    }

    public void endObject() throws IOException {
        --this.indentDepth;
        if (this.writtenFlags.pop().booleanValue()) {
            this.nextLine();
        }
        this.indent();
        this.out.write("}");
        this.writtenFlags.update(true);
    }

    public void beginArray() throws IOException {
        this.writePendedName();
        this.out.write("[");
        this.nextLine();
        ++this.indentDepth;
        this.writtenFlags.push(false);
    }

    public void endArray() throws IOException {
        --this.indentDepth;
        if (this.writtenFlags.pop().booleanValue()) {
            this.nextLine();
        }
        this.indent();
        this.out.write("]");
        this.writtenFlags.update(true);
    }

    private void indent() throws IOException {
        if (this.prettyPrint) {
            for (int i = 0; i < this.indentDepth; ++i) {
                this.out.write(this.indentString);
            }
        }
    }

    private void nextLine() throws IOException {
        if (this.prettyPrint) {
            this.out.write("\n");
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    public String toString() {
        return this.out.toString();
    }

    private void checkCircularReference(Object wrapper, Object member) throws IOException {
        if (wrapper.equals(member)) {
            throw new IOException("JSON Serialization Failure: A circular reference was detected while converting a member object [" + member + "] in [" + wrapper + "]");
        }
    }

    private static String escape(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        int len = string.length();
        char c = '\u0000';
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }
}

