/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.statistic;

import com.aspectran.core.util.ToStringBuilder;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;

public class SampleStatistic {
    protected final LongAccumulator max = new LongAccumulator(Math::max, 0L);
    protected final AtomicLong total = new AtomicLong();
    protected final AtomicLong count = new AtomicLong();
    protected final LongAdder totalVariance100 = new LongAdder();

    public void reset() {
        this.max.reset();
        this.total.set(0L);
        this.count.set(0L);
        this.totalVariance100.reset();
    }

    public void record(long sample) {
        long total = this.total.addAndGet(sample);
        long count = this.count.incrementAndGet();
        if (count > 1L) {
            long mean10 = total * 10L / count;
            long delta10 = sample * 10L - mean10;
            this.totalVariance100.add(delta10 * delta10);
        }
        this.max.accumulate(sample);
    }

    public long getMax() {
        return this.max.get();
    }

    public long getTotal() {
        return this.total.get();
    }

    public long getCount() {
        return this.count.get();
    }

    public double getMean() {
        long count = this.getCount();
        return count > 0L ? (double)this.total.get() / (double)this.count.get() : 0.0;
    }

    public double getVariance() {
        long variance100 = this.totalVariance100.sum();
        long count = this.getCount();
        return count > 1L ? (double)variance100 / 100.0 / (double)(count - 1L) : 0.0;
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode()));
        tsb.append("count", this.getCount());
        tsb.append("max", this.getMax());
        tsb.append("total", this.getTotal());
        tsb.append("stddev", this.getStdDev());
        return tsb.toString();
    }
}

