/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.wildcard;

import com.aspectran.core.util.wildcard.WildcardMasker;
import com.aspectran.core.util.wildcard.WildcardMatcher;
import java.util.Objects;

public class WildcardPattern {
    private static final char ESCAPE_CHAR = '\\';
    private static final char SPACE_CHAR = ' ';
    public static final char STAR_CHAR = '*';
    public static final char QUESTION_CHAR = '?';
    public static final char PLUS_CHAR = '+';
    static final int LITERAL_TYPE = 1;
    static final int STAR_TYPE = 2;
    static final int STAR_STAR_TYPE = 3;
    static final int QUESTION_TYPE = 4;
    static final int PLUS_TYPE = 5;
    static final int SKIP_TYPE = 8;
    static final int SEPARATOR_TYPE = 9;
    static final int EOT_TYPE = 0;
    private final String patternString;
    private final char separator;
    private final char[] tokens;
    private final int[] types;
    private final float weight;

    public WildcardPattern(String patternString) {
        this(patternString, '\u0000');
    }

    public WildcardPattern(String patternString, char separator) {
        this.patternString = patternString;
        this.separator = separator;
        this.tokens = patternString.toCharArray();
        this.types = new int[this.tokens.length];
        this.weight = this.parse();
    }

    private float parse() {
        int i;
        boolean star = false;
        boolean esc = false;
        int ptype = 8;
        int pindex = 0;
        for (i = 0; i < this.tokens.length; ++i) {
            if (this.tokens[i] == '*') {
                if (esc) {
                    esc = false;
                } else if (star) {
                    this.types[i - 1] = 8;
                    this.types[i] = 3;
                    star = false;
                } else {
                    this.types[i] = 2;
                    star = true;
                }
                if (ptype == 4 && this.types[i] == 2) {
                    this.types[pindex] = 8;
                }
            } else if (this.tokens[i] == '?') {
                if (esc) {
                    this.types[i - 1] = 8;
                    esc = false;
                } else {
                    this.types[i] = 4;
                }
                if (ptype == 2 && this.types[i] == 4) {
                    this.types[i] = 8;
                }
            } else if (this.tokens[i] == '+') {
                if (esc) {
                    this.types[i - 1] = 8;
                    esc = false;
                } else {
                    this.types[i] = 5;
                }
                if (ptype == 2 && this.types[i] == 43) {
                    this.types[i] = 8;
                }
            } else if (this.tokens[i] == this.separator) {
                esc = false;
                this.types[i] = 9;
            } else if (this.tokens[i] == '\\') {
                this.types[i] = 8;
                esc = true;
            } else if (esc) {
                this.types[i - 1] = 1;
            } else {
                this.types[i] = 1;
            }
            if (this.tokens[i] != '*' && star) {
                star = false;
            }
            if (this.types[i] == 8) continue;
            ptype = this.types[i];
            pindex = i;
        }
        int s = 0;
        for (i = 0; i < this.tokens.length; ++i) {
            if (this.types[i] == 8) {
                ++s;
                this.tokens[i] = 32;
                this.types[i] = 0;
                continue;
            }
            if (s <= 0) continue;
            this.tokens[i - s] = this.tokens[i];
            this.types[i - s] = this.types[i];
            this.tokens[i] = 32;
            this.types[i] = 0;
        }
        float weight = 0.0f;
        for (int i2 = 0; i2 < this.types.length && this.types[i2] != 0; ++i2) {
            weight += (float)((i2 + 1) * this.types[i2]) / 10.0f;
        }
        return weight;
    }

    public char getSeparator() {
        return this.separator;
    }

    protected char[] getTokens() {
        return this.tokens;
    }

    protected int[] getTypes() {
        return this.types;
    }

    public float getWeight() {
        return this.weight;
    }

    public boolean matches(String compareString) {
        return WildcardMatcher.matches(this, compareString);
    }

    public String mask(String nakedString) {
        return WildcardMasker.mask(this, nakedString);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        WildcardPattern wp = (WildcardPattern)obj;
        return Objects.equals(wp.toString(), this.patternString) && Objects.equals(Character.valueOf(wp.getSeparator()), Character.valueOf(this.getSeparator()));
    }

    public int hashCode() {
        int result = this.patternString.hashCode();
        result = 31 * result + this.separator;
        return result;
    }

    public String toString() {
        return this.patternString;
    }

    public static WildcardPattern compile(String patternString) {
        return new WildcardPattern(patternString);
    }

    public static WildcardPattern compile(String patternString, char separator) {
        return new WildcardPattern(patternString, separator);
    }

    public static boolean hasWildcards(String str) {
        char[] ca;
        for (char c : ca = str.toCharArray()) {
            if (c != '*' && c != '?' && c != '+') continue;
            return true;
        }
        return false;
    }
}

