/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.scheduler.service;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityException;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.scheduler.activity.JobActivity;
import com.aspectran.scheduler.service.SchedulerService;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ActivityLauncherJob
implements Job {
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            SchedulerService service;
            JobDetail jobDetail = jobExecutionContext.getJobDetail();
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            ScheduledJobRule jobRule = (ScheduledJobRule)jobDataMap.get((Object)"JOB_RULE");
            if (!jobRule.isDisabled() && (service = (SchedulerService)jobDataMap.get((Object)"SERVICE")).isActive()) {
                Activity activity = this.runActivity(service.getActivityContext(), jobExecutionContext, jobRule.getTransletName());
                jobExecutionContext.setResult((Object)activity);
            }
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Activity runActivity(ActivityContext context, JobExecutionContext jobExecutionContext, String transletName) throws ActivityException {
        try (JobActivity activity = null;){
            activity = new JobActivity(context, jobExecutionContext);
            activity.prepare(transletName);
            activity.perform();
        }
        return activity;
    }
}

