/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.context.expr.ItemEvaluator;
import com.aspectran.core.context.expr.ItemExpression;
import com.aspectran.core.context.rule.InvokeActionRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.ItemRuleUtils;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.util.BeanUtils;
import com.aspectran.core.util.MethodUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class InvokeAction
implements Executable {
    private static final Log log = LogFactory.getLog(InvokeAction.class);
    private final InvokeActionRule invokeActionRule;
    private Boolean requiresTranslet;

    public InvokeAction(InvokeActionRule invokeActionRule) {
        this.invokeActionRule = invokeActionRule;
    }

    @Override
    public Object execute(Activity activity) throws Exception {
        Object bean = null;
        if (this.invokeActionRule.getBeanClass() != null) {
            bean = activity.getBean(this.invokeActionRule.getBeanClass());
        } else if (this.invokeActionRule.getBeanId() != null) {
            bean = activity.getBean(this.invokeActionRule.getBeanId());
        }
        if (bean == null) {
            throw new ActionExecutionException("No bean found for " + this.invokeActionRule);
        }
        return this.execute(activity, bean);
    }

    protected Object execute(Activity activity, Object bean) throws Exception {
        try {
            Object result;
            Method method;
            ItemRuleMap propertyItemRuleMap = this.invokeActionRule.getPropertyItemRuleMap();
            ItemRuleMap argumentItemRuleMap = this.invokeActionRule.getArgumentItemRuleMap();
            ItemExpression evaluator = null;
            if (propertyItemRuleMap != null && !propertyItemRuleMap.isEmpty() || argumentItemRuleMap != null && !argumentItemRuleMap.isEmpty()) {
                evaluator = new ItemExpression(activity);
            }
            if (propertyItemRuleMap != null && !propertyItemRuleMap.isEmpty()) {
                Map<String, Object> valueMap = evaluator.evaluate(propertyItemRuleMap);
                for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
                    BeanUtils.setProperty(bean, entry.getKey(), entry.getValue());
                }
            }
            if ((method = this.invokeActionRule.getMethod()) != null) {
                if (argumentItemRuleMap != null && !argumentItemRuleMap.isEmpty()) {
                    Object[] args = InvokeAction.createArguments(activity, argumentItemRuleMap, evaluator, this.invokeActionRule.isRequiresTranslet());
                    return InvokeAction.invokeMethod(bean, method, args);
                }
                return InvokeAction.invokeMethod(activity, bean, method, this.invokeActionRule.isRequiresTranslet());
            }
            String methodName = this.invokeActionRule.getMethodName();
            if (activity.getTranslet() != null) {
                if (this.requiresTranslet == null) {
                    try {
                        result = InvokeAction.invokeMethod(activity, bean, methodName, argumentItemRuleMap, evaluator, true);
                        this.requiresTranslet = Boolean.TRUE;
                    }
                    catch (NoSuchMethodException e) {
                        if (log.isTraceEnabled()) {
                            log.trace("No have a Translet argument on bean method " + this.invokeActionRule);
                        }
                        this.requiresTranslet = Boolean.FALSE;
                        result = InvokeAction.invokeMethod(activity, bean, methodName, argumentItemRuleMap, evaluator, false);
                    }
                } else {
                    result = InvokeAction.invokeMethod(activity, bean, methodName, argumentItemRuleMap, evaluator, this.requiresTranslet);
                }
            } else {
                result = InvokeAction.invokeMethod(activity, bean, methodName, argumentItemRuleMap, evaluator, false);
            }
            return result;
        }
        catch (ActionExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActionExecutionException("Failed to execute action " + this, (Throwable)e);
        }
    }

    public InvokeActionRule getInvokeActionRule() {
        return this.invokeActionRule;
    }

    @Override
    public String getActionId() {
        return this.invokeActionRule.getActionId();
    }

    @Override
    public boolean isHidden() {
        return this.invokeActionRule.isHidden();
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ACTION;
    }

    @Override
    public <T> T getActionRule() {
        return (T)this.invokeActionRule;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("invoke", this.invokeActionRule);
        return tsb.toString();
    }

    private static Object invokeMethod(Activity activity, Object bean, Method method, boolean requiresTranslet) throws Exception {
        Object[] args = requiresTranslet ? new Object[]{activity.getTranslet()} : MethodUtils.EMPTY_OBJECT_ARRAY;
        return InvokeAction.invokeMethod(bean, method, args);
    }

    private static Object invokeMethod(Object bean, Method method, Object[] args) throws Exception {
        try {
            return method.invoke(bean, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    private static Object invokeMethod(Activity activity, Object bean, String methodName, ItemRuleMap argumentItemRuleMap, ItemEvaluator evaluator, boolean requiresTranslet) throws Exception {
        Class[] argsTypes = null;
        Object[] argsObjects = null;
        if (argumentItemRuleMap != null && !argumentItemRuleMap.isEmpty()) {
            int argIndex;
            if (evaluator == null) {
                evaluator = new ItemExpression(activity);
            }
            Map<String, Object> valueMap = evaluator.evaluate(argumentItemRuleMap);
            int argSize = argumentItemRuleMap.size();
            if (requiresTranslet) {
                argIndex = 1;
                argsTypes = new Class[argSize + argIndex];
                argsObjects = new Object[argsTypes.length];
                argsTypes[0] = Translet.class;
                argsObjects[0] = activity.getTranslet();
            } else {
                argIndex = 0;
                argsTypes = new Class[argSize];
                argsObjects = new Object[argsTypes.length];
            }
            for (ItemRule ir : argumentItemRuleMap.values()) {
                Object o = valueMap.get(ir.getName());
                argsTypes[argIndex] = ItemRuleUtils.getPrototypeClass(ir, o);
                argsObjects[argIndex] = o;
                ++argIndex;
            }
        } else if (requiresTranslet) {
            argsTypes = new Class[]{Translet.class};
            argsObjects = new Object[]{activity.getTranslet()};
        }
        try {
            return MethodUtils.invokeMethod(bean, methodName, argsObjects, argsTypes);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    private static Object[] createArguments(Activity activity, ItemRuleMap argumentItemRuleMap, ItemEvaluator evaluator, boolean requiresTranslet) {
        Object[] args;
        int index;
        if (evaluator == null) {
            evaluator = new ItemExpression(activity);
        }
        int size = argumentItemRuleMap.size();
        if (requiresTranslet) {
            index = 1;
            args = new Object[size + index];
            args[0] = activity.getTranslet();
        } else {
            index = 0;
            args = new Object[size];
        }
        Map<String, Object> valueMap = evaluator.evaluate(argumentItemRuleMap);
        for (String name : argumentItemRuleMap.keySet()) {
            Object o;
            args[index] = o = valueMap.get(name);
            ++index;
        }
        return args;
    }
}

