/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.AponTransformResponse;
import com.aspectran.core.activity.response.transform.JsonTransformResponse;
import com.aspectran.core.activity.response.transform.NoneTransformResponse;
import com.aspectran.core.activity.response.transform.TextTransformResponse;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.XmlTransformResponse;
import com.aspectran.core.activity.response.transform.XslTransformResponse;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.type.ContentType;
import com.aspectran.core.context.rule.type.TransformType;

public class TransformResponseFactory {
    public static Response create(TransformRule transformRule) {
        TransformResponse res;
        TransformType type = transformRule.getTransformType();
        if (type == TransformType.APON) {
            if (transformRule.getContentType() == null) {
                transformRule.setContentType(ContentType.APPLICATION_APON.toString());
            }
            res = new AponTransformResponse(transformRule);
        } else if (type == TransformType.JSON) {
            if (transformRule.getContentType() == null) {
                transformRule.setContentType(ContentType.TEXT_PLAIN.toString());
            }
            res = new JsonTransformResponse(transformRule);
        } else if (type == TransformType.TEXT) {
            res = new TextTransformResponse(transformRule);
        } else if (type == TransformType.XML) {
            if (transformRule.getContentType() == null) {
                transformRule.setContentType(ContentType.APPLICATION_XML.toString());
            }
            res = new XmlTransformResponse(transformRule);
        } else {
            res = type == TransformType.XSL ? new XslTransformResponse(transformRule) : new NoneTransformResponse(transformRule);
        }
        return res;
    }
}

