/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.adapter;

import com.aspectran.core.adapter.ApplicationAdapter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;

public abstract class AbstractApplicationAdapter
implements ApplicationAdapter {
    private final String basePath;
    private final ClassLoader classLoader;

    public AbstractApplicationAdapter(String basePath, ClassLoader classLoader) {
        this.basePath = basePath;
        this.classLoader = classLoader;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String toRealPath(String filePath) throws IOException {
        File file = this.toRealPathAsFile(filePath);
        return file.getCanonicalPath();
    }

    @Override
    public File toRealPathAsFile(String filePath) throws IOException {
        File file;
        if (filePath.startsWith("file:")) {
            URI uri = URI.create(filePath);
            file = new File(uri);
        } else if (filePath.startsWith("classpath:")) {
            URL url = this.getClassLoader().getResource(filePath);
            if (url == null) {
                throw new IOException("Could not find the resource with the given name: " + filePath);
            }
            file = new File(url.getFile());
        } else {
            file = this.basePath != null ? new File(this.basePath, filePath) : new File(filePath);
        }
        return file;
    }
}

