/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean;

import com.aspectran.core.component.bean.AnnotatedConfigParser;
import com.aspectran.core.component.bean.AnnotatedConfigRelater;
import com.aspectran.core.component.bean.BeanRuleAnalyzer;
import com.aspectran.core.component.bean.BeanRuleException;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.ablility.FactoryBean;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.core.component.bean.ablility.InitializableTransletBean;
import com.aspectran.core.component.bean.annotation.Component;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.core.component.bean.aware.ClassLoaderAware;
import com.aspectran.core.component.bean.aware.CurrentActivityAware;
import com.aspectran.core.component.bean.aware.EnvironmentAware;
import com.aspectran.core.component.bean.scan.BeanClassScanFilter;
import com.aspectran.core.component.bean.scan.BeanClassScanner;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.AutowireRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.params.FilterParameters;
import com.aspectran.core.context.rule.type.ScopeType;
import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.PrefixSuffixPattern;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class BeanRuleRegistry {
    private static final Log log = LogFactory.getLog(BeanRuleRegistry.class);
    private final Map<String, BeanRule> idBasedBeanRuleMap = new LinkedHashMap<String, BeanRule>();
    private final Map<Class<?>, Set<BeanRule>> typeBasedBeanRuleMap = new LinkedHashMap();
    private final Map<Class<?>, BeanRule> configurableBeanRuleMap = new LinkedHashMap();
    private final Set<Class<?>> ignoredDependencyInterfaces = new HashSet();
    private final Set<BeanRule> postProcessBeanRuleMap = new HashSet<BeanRule>();
    private final Set<String> importantBeanIdSet = new HashSet<String>();
    private final Set<Class<?>> importantBeanTypeSet = new HashSet();
    private final ClassLoader classLoader;

    public BeanRuleRegistry(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.ignoreDependencyInterface(DisposableBean.class);
        this.ignoreDependencyInterface(FactoryBean.class);
        this.ignoreDependencyInterface(InitializableBean.class);
        this.ignoreDependencyInterface(InitializableTransletBean.class);
        this.ignoreDependencyInterface(ActivityContextAware.class);
        this.ignoreDependencyInterface(ApplicationAdapterAware.class);
        this.ignoreDependencyInterface(ClassLoaderAware.class);
        this.ignoreDependencyInterface(CurrentActivityAware.class);
        this.ignoreDependencyInterface(EnvironmentAware.class);
        this.ignoreDependencyInterface(Comparable.class);
        this.ignoreDependencyInterface(CharSequence.class);
        this.ignoreDependencyInterface(Serializable.class);
        this.ignoreDependencyInterface(Closeable.class);
    }

    public BeanRule getBeanRule(String id) {
        return this.idBasedBeanRuleMap.get(id);
    }

    public BeanRule[] getBeanRules(String name) throws ClassNotFoundException {
        if (name.startsWith("class:")) {
            String className = name.substring("class:".length());
            Class<?> type = this.classLoader.loadClass(className);
            return this.getBeanRules(type);
        }
        BeanRule beanRule = this.getBeanRule(name);
        if (beanRule != null) {
            return new BeanRule[]{this.getBeanRule(name)};
        }
        return null;
    }

    public BeanRule[] getBeanRules(Class<?> type) {
        Set<BeanRule> list = this.typeBasedBeanRuleMap.get(type);
        if (list != null && !list.isEmpty()) {
            return list.toArray(new BeanRule[0]);
        }
        return null;
    }

    public BeanRule getBeanRuleForConfig(Class<?> type) {
        return this.configurableBeanRuleMap.get(type);
    }

    public boolean containsBeanRule(String id) {
        return this.idBasedBeanRuleMap.containsKey(id);
    }

    public boolean containsBeanRule(Class<?> type) {
        return this.typeBasedBeanRuleMap.containsKey(type);
    }

    public Map<String, BeanRule> getIdBasedBeanRuleMap() {
        return this.idBasedBeanRuleMap;
    }

    public Map<Class<?>, Set<BeanRule>> getTypeBasedBeanRuleMap() {
        return this.typeBasedBeanRuleMap;
    }

    public Map<Class<?>, BeanRule> getConfigurableBeanRuleMap() {
        return this.configurableBeanRuleMap;
    }

    public Collection<BeanRule> getIdBasedBeanRules() {
        return this.idBasedBeanRuleMap.values();
    }

    public Collection<Set<BeanRule>> getTypeBasedBeanRules() {
        return this.typeBasedBeanRuleMap.values();
    }

    public Collection<BeanRule> getConfigurableBeanRules() {
        return this.configurableBeanRuleMap.values();
    }

    public Collection<Class<?>> findConfigBeanClassesWithAnnotation(Class<? extends Annotation> annotationType) {
        ArrayList result = new ArrayList();
        for (BeanRule beanRule : this.configurableBeanRuleMap.values()) {
            Class<?> targetBeanClass = beanRule.getTargetBeanClass();
            if (!targetBeanClass.isAnnotationPresent(annotationType)) continue;
            result.add(targetBeanClass);
        }
        return result;
    }

    public void scanConfigurableBeans(String ... basePackages) throws BeanRuleException {
        if (basePackages == null || basePackages.length == 0) {
            return;
        }
        log.info("Auto component scanning on packages [" + StringUtils.joinCommaDelimitedList(basePackages) + "]");
        for (String basePackage : basePackages) {
            BeanClassScanner scanner = new BeanClassScanner(this.classLoader);
            ArrayList beanRules = new ArrayList();
            scanner.scan(basePackage + ".**", (resourceName, targetClass) -> {
                if (targetClass.isAnnotationPresent(Component.class)) {
                    BeanRule beanRule = new BeanRule();
                    beanRule.setBeanClass(targetClass);
                    beanRule.setScopeType(ScopeType.SINGLETON);
                    beanRules.add(beanRule);
                }
            });
            for (BeanRule beanRule : beanRules) {
                this.saveConfigurableBeanRule(beanRule);
            }
        }
    }

    public void addBeanRule(BeanRule beanRule) throws IllegalRuleException {
        if (beanRule == null) {
            throw new IllegalArgumentException("beanRule must not be null");
        }
        String scanPattern = beanRule.getScanPattern();
        if (scanPattern != null) {
            PrefixSuffixPattern prefixSuffixPattern = PrefixSuffixPattern.parse(beanRule.getId());
            ArrayList scannedBeanRules = new ArrayList();
            BeanClassScanner scanner = this.createBeanClassScanner(beanRule);
            scanner.scan(scanPattern, (resourceName, targetClass) -> {
                BeanRule replicated = beanRule.replicate();
                if (prefixSuffixPattern != null) {
                    replicated.setId(prefixSuffixPattern.join(resourceName));
                } else if (beanRule.getId() != null) {
                    replicated.setId(beanRule.getId() + resourceName);
                } else if (beanRule.getMaskPattern() != null) {
                    replicated.setId(resourceName);
                }
                replicated.setBeanClass(targetClass);
                scannedBeanRules.add(replicated);
            });
            for (BeanRule scannedBeanRule : scannedBeanRules) {
                this.dissectBeanRule(scannedBeanRule);
            }
        } else {
            this.dissectBeanRule(beanRule);
        }
    }

    private BeanClassScanner createBeanClassScanner(BeanRule beanRule) throws IllegalRuleException {
        BeanClassScanner scanner = new BeanClassScanner(this.classLoader);
        if (beanRule.getFilterParameters() != null) {
            String[] excludePatterns;
            FilterParameters filterParameters = beanRule.getFilterParameters();
            String beanClassScanFilterClassName = filterParameters.getString(FilterParameters.filterClass);
            if (beanClassScanFilterClassName != null) {
                BeanClassScanFilter beanClassScanFilter;
                try {
                    Class<?> filterClass = this.classLoader.loadClass(beanClassScanFilterClassName);
                    beanClassScanFilter = (BeanClassScanFilter)ClassUtils.createInstance(filterClass);
                }
                catch (Exception e) {
                    throw new IllegalRuleException("Failed to instantiate BeanClassScanFilter [" + beanClassScanFilterClassName + "]", e);
                }
                scanner.setBeanClassScanFilter(beanClassScanFilter);
            }
            if ((excludePatterns = filterParameters.getStringArray(FilterParameters.exclude)) != null) {
                scanner.setExcludePatterns(excludePatterns);
            }
        }
        if (beanRule.getMaskPattern() != null) {
            scanner.setBeanIdMaskPattern(beanRule.getMaskPattern());
        }
        return scanner;
    }

    private void dissectBeanRule(BeanRule beanRule) throws BeanRuleException {
        Class<?> targetBeanClass = BeanRuleAnalyzer.determineBeanClass(beanRule);
        if (targetBeanClass == null) {
            this.postProcessBeanRuleMap.add(beanRule);
        } else {
            if (beanRule.getId() != null) {
                this.saveBeanRule(beanRule.getId(), beanRule);
            }
            if (!beanRule.isFactoryOffered()) {
                if (targetBeanClass.isAnnotationPresent(Component.class)) {
                    this.saveConfigurableBeanRule(beanRule);
                } else {
                    this.saveBeanRule(targetBeanClass, beanRule);
                    this.saveBeanRuleWithInterfaces(targetBeanClass, beanRule);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("add BeanRule " + beanRule);
            }
        }
    }

    private void saveBeanRule(String beanId, BeanRule beanRule) throws BeanRuleException {
        if (this.importantBeanIdSet.contains(beanId)) {
            throw new BeanRuleException("Already exists an ID-based bean that can not be overridden; Duplicated bean", beanRule);
        }
        if (beanRule.isImportant()) {
            this.importantBeanIdSet.add(beanRule.getId());
        }
        this.idBasedBeanRuleMap.put(beanId, beanRule);
    }

    private void saveBeanRule(Class<?> beanClass, BeanRule beanRule) throws BeanRuleException {
        if (this.importantBeanTypeSet.contains(beanClass)) {
            throw new BeanRuleException("Already exists a type-based bean that can not be overridden; Duplicated bean", beanRule);
        }
        if (beanRule.isImportant()) {
            this.importantBeanTypeSet.add(beanClass);
        }
        Set set = this.typeBasedBeanRuleMap.computeIfAbsent(beanClass, k -> new HashSet());
        set.add(beanRule);
    }

    private void saveBeanRuleWithInterfaces(Class<?> beanClass, BeanRule beanRule) throws BeanRuleException {
        if (beanClass.isInterface()) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = beanClass.getInterfaces()) {
                if (this.ignoredDependencyInterfaces.contains(ifc) || !ClassUtils.isVisible(ifc, this.classLoader)) continue;
                this.saveBeanRule(ifc, beanRule);
            }
        } else {
            for (Class<?> current = beanClass; current != null; current = current.getSuperclass()) {
                Class<?>[] ifcs;
                for (Class<?> ifc : ifcs = current.getInterfaces()) {
                    if (this.ignoredDependencyInterfaces.contains(ifc) || !ClassUtils.isVisible(ifc, this.classLoader)) continue;
                    this.saveBeanRule(ifc, beanRule);
                    this.saveBeanRuleWithInterfaces(ifc, beanRule);
                }
            }
        }
    }

    private void saveConfigurableBeanRule(BeanRule beanRule) throws BeanRuleException {
        if (beanRule.getBeanClass() == null) {
            throw new BeanRuleException("No specified bean class", beanRule);
        }
        this.configurableBeanRuleMap.put(beanRule.getBeanClass(), beanRule);
    }

    public void addInnerBeanRule(BeanRule beanRule) throws BeanRuleException {
        if (beanRule == null) {
            throw new IllegalArgumentException("beanRule must not be null");
        }
        if (!beanRule.isInnerBean()) {
            throw new BeanRuleException("Not an inner bean", beanRule);
        }
        Class<?> targetBeanClass = BeanRuleAnalyzer.determineBeanClass(beanRule);
        if (targetBeanClass == null) {
            this.postProcessBeanRuleMap.add(beanRule);
        }
    }

    public void postProcess(ContextRuleAssistant assistant) throws IllegalRuleException {
        if (!this.postProcessBeanRuleMap.isEmpty()) {
            for (BeanRule beanRule : this.postProcessBeanRuleMap) {
                if (!beanRule.isInnerBean() && beanRule.getId() != null) {
                    this.saveBeanRule(beanRule.getId(), beanRule);
                }
                if (!beanRule.isFactoryOffered()) continue;
                Class<?> offeredFactoryBeanClass = this.resolveOfferedFactoryBeanClass(beanRule);
                Class<?> targetBeanClass = BeanRuleAnalyzer.determineFactoryMethodTargetBeanClass(offeredFactoryBeanClass, beanRule);
                if (beanRule.getInitMethodName() != null) {
                    BeanRuleAnalyzer.determineInitMethod(targetBeanClass, beanRule);
                }
                if (beanRule.getDestroyMethodName() != null) {
                    BeanRuleAnalyzer.determineDestroyMethod(targetBeanClass, beanRule);
                }
                if (beanRule.isInnerBean()) continue;
                this.saveBeanRule(targetBeanClass, beanRule);
                this.saveBeanRuleWithInterfaces(targetBeanClass, beanRule);
            }
            this.postProcessBeanRuleMap.clear();
        }
        this.importantBeanIdSet.clear();
        this.importantBeanTypeSet.clear();
        this.parseAnnotatedConfig(assistant);
    }

    private void parseAnnotatedConfig(final ContextRuleAssistant assistant) throws IllegalRuleException {
        AnnotatedConfigRelater relater = new AnnotatedConfigRelater(){

            @Override
            public void relay(Class<?> targetBeanClass, BeanRule beanRule) throws IllegalRuleException {
                if (beanRule.getId() != null) {
                    BeanRuleRegistry.this.saveBeanRule(beanRule.getId(), beanRule);
                }
                BeanRuleRegistry.this.saveBeanRule(targetBeanClass, beanRule);
                BeanRuleRegistry.this.saveBeanRuleWithInterfaces(targetBeanClass, beanRule);
            }

            @Override
            public void relay(AspectRule aspectRule) throws IllegalRuleException {
                assistant.addAspectRule(aspectRule);
            }

            @Override
            public void relay(ScheduleRule scheduleRule) throws IllegalRuleException {
                assistant.addScheduleRule(scheduleRule);
            }

            @Override
            public void relay(TransletRule transletRule) throws IllegalRuleException {
                assistant.addTransletRule(transletRule);
            }

            @Override
            public void relay(AutowireRule autowireRule) throws IllegalRuleException {
                assistant.resolveBeanClass(autowireRule);
            }
        };
        AnnotatedConfigParser parser = new AnnotatedConfigParser(assistant, relater);
        parser.parse();
    }

    private Class<?> resolveOfferedFactoryBeanClass(BeanRule beanRule) throws BeanRuleException {
        BeanRule offeredFactoryBeanRule;
        if (beanRule.getFactoryBeanClass() == null) {
            offeredFactoryBeanRule = this.getBeanRule(beanRule.getFactoryBeanId());
            if (offeredFactoryBeanRule == null) {
                throw new BeanRuleException("No factory bean named '" + beanRule.getFactoryBeanId() + "' is defined; Caller bean ", beanRule);
            }
        } else {
            BeanRule[] beanRules = this.getBeanRules(beanRule.getFactoryBeanClass());
            if (beanRules == null || beanRules.length == 0) {
                throw new BeanRuleException("No matching factory bean of type '" + beanRule.getFactoryBeanClass().getName() + "' found", beanRule);
            }
            if (beanRules.length > 1) {
                throw new BeanRuleException("No unique factory bean of type '" + beanRule.getFactoryBeanClass().getName() + "' is defined: expected single matching bean but found " + beanRules.length + ": (" + NoUniqueBeanException.getBeanDescriptions(beanRules) + "); Caller bean ", beanRule);
            }
            offeredFactoryBeanRule = beanRules[0];
        }
        if (offeredFactoryBeanRule.isFactoryOffered()) {
            throw new BeanRuleException("An offered factory bean can not call another offered factory bean; Caller bean ", beanRule);
        }
        return offeredFactoryBeanRule.getTargetBeanClass();
    }

    public void ignoreDependencyInterface(Class<?> ifc) {
        this.ignoredDependencyInterfaces.add(ifc);
    }
}

