/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean.scope;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.component.bean.BeanInstance;
import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.scope.Scope;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.util.MethodUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;

public abstract class AbstractScope
implements Scope {
    private static final Log log = LogFactory.getLog(AbstractScope.class);
    private final Map<BeanRule, BeanInstance> scopedBeanInstanceMap = new LinkedHashMap<BeanRule, BeanInstance>();

    @Override
    public BeanInstance getBeanInstance(BeanRule beanRule) {
        return this.scopedBeanInstanceMap.get(beanRule);
    }

    @Override
    public void putBeanInstance(Activity activity, BeanRule beanRule, BeanInstance beanInstance) {
        if (activity == null) {
            throw new IllegalArgumentException("activity must not be null");
        }
        if (beanRule == null) {
            throw new IllegalArgumentException("beanRule must not be null");
        }
        if (beanInstance == null) {
            throw new IllegalArgumentException("beanInstance must not be null");
        }
        this.scopedBeanInstanceMap.put(beanRule, beanInstance);
    }

    @Override
    public BeanRule getBeanRule(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("bean must not be null");
        }
        for (Map.Entry<BeanRule, BeanInstance> entry : this.scopedBeanInstanceMap.entrySet()) {
            if (entry.getValue().getBean() != bean) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public boolean containsBeanRule(BeanRule beanRule) {
        return this.scopedBeanInstanceMap.containsKey(beanRule);
    }

    @Override
    public void destroy(Object bean) throws Exception {
        BeanRule beanRule = this.getBeanRule(bean);
        if (beanRule != null) {
            this.doDestroy(beanRule, bean);
            this.scopedBeanInstanceMap.remove(beanRule);
        }
    }

    @Override
    public void destroy() {
        if (log.isDebugEnabled() && !this.scopedBeanInstanceMap.isEmpty()) {
            log.debug("Destroy " + (Object)((Object)this.getScopeType()) + " scoped beans from " + this);
        }
        ArrayList<BeanRule> beanRules = new ArrayList<BeanRule>(this.scopedBeanInstanceMap.keySet());
        ListIterator iter = beanRules.listIterator(beanRules.size());
        while (iter.hasPrevious()) {
            BeanRule beanRule = (BeanRule)iter.previous();
            BeanInstance instance = this.scopedBeanInstanceMap.get(beanRule);
            Object bean = instance.getBean();
            if (bean == null) continue;
            try {
                this.doDestroy(beanRule, bean);
            }
            catch (Exception e) {
                log.error("Could not destroy " + (Object)((Object)this.getScopeType()) + " scoped bean " + beanRule, e);
            }
        }
        this.scopedBeanInstanceMap.clear();
    }

    private void doDestroy(BeanRule beanRule, Object bean) throws Exception {
        if (bean != null) {
            if (beanRule.isDisposableBean()) {
                ((DisposableBean)bean).destroy();
            } else if (beanRule.getDestroyMethodName() != null) {
                Method destroyMethod = beanRule.getDestroyMethod();
                destroyMethod.invoke(bean, MethodUtils.EMPTY_OBJECT_ARRAY);
            }
        }
    }
}

