/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.schedule;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.assistant.AssistantLocal;
import com.aspectran.core.context.rule.assistant.DefaultSettings;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ScheduleRuleRegistry
extends AbstractComponent {
    private static final Log log = LogFactory.getLog(ScheduleRuleRegistry.class);
    private final Map<String, ScheduleRule> scheduleRuleMap = new LinkedHashMap<String, ScheduleRule>();
    private AssistantLocal assistantLocal;

    public void setAssistantLocal(AssistantLocal assistantLocal) {
        this.assistantLocal = assistantLocal;
    }

    public Collection<ScheduleRule> getScheduleRules() {
        return this.scheduleRuleMap.values();
    }

    public ScheduleRule getScheduleRule(String scheduleId) {
        return this.scheduleRuleMap.get(scheduleId);
    }

    public boolean contains(String scheduleId) {
        return this.scheduleRuleMap.containsKey(scheduleId);
    }

    public void addScheduleRule(ScheduleRule scheduleRule) throws IllegalRuleException {
        DefaultSettings defaultSettings;
        if (scheduleRule == null) {
            throw new IllegalArgumentException("scheduleRule must not be null");
        }
        if (scheduleRule.getSchedulerBeanId() == null && this.assistantLocal != null && (defaultSettings = this.assistantLocal.getDefaultSettings()) != null && defaultSettings.getDefaultSchedulerBean() != null) {
            scheduleRule.setSchedulerBeanId(defaultSettings.getDefaultSchedulerBean());
        }
        if (scheduleRule.getSchedulerBeanId() != null) {
            if (scheduleRule.getSchedulerBeanClass() == null) {
                this.assistantLocal.getAssistant().resolveBeanClass(scheduleRule);
            }
        } else if (scheduleRule.getSchedulerBeanClass() != null) {
            scheduleRule.setSchedulerBeanId("class:" + scheduleRule.getSchedulerBeanClass().getName());
        }
        this.scheduleRuleMap.put(scheduleRule.getId(), scheduleRule);
        if (log.isTraceEnabled()) {
            log.trace("add ScheduleRule " + scheduleRule);
        }
    }

    public Set<ScheduledJobRule> getScheduledJobRules(String[] transletNames) {
        LinkedHashSet<ScheduledJobRule> scheduledJobRules = new LinkedHashSet<ScheduledJobRule>();
        if (transletNames != null) {
            for (ScheduleRule scheduleRule : this.getScheduleRules()) {
                for (ScheduledJobRule jobRule : scheduleRule.getScheduledJobRuleList()) {
                    for (String transletName : transletNames) {
                        if (!jobRule.getTransletName().equals(transletName)) continue;
                        scheduledJobRules.add(jobRule);
                    }
                }
            }
        }
        return scheduledJobRules;
    }

    @Override
    protected void doInitialize() {
    }

    @Override
    protected void doDestroy() {
        this.scheduleRuleMap.clear();
    }
}

