/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.session.DefaultSession;
import com.aspectran.core.component.session.SessionCache;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionStore;
import com.aspectran.core.component.session.UnreadableSessionDataException;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.thread.Locker;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public abstract class AbstractSessionCache
extends AbstractComponent
implements SessionCache {
    private static final Log log = LogFactory.getLog(AbstractSessionCache.class);
    private final SessionHandler sessionHandler;
    private final SessionStore sessionStore;
    private final boolean clustered;
    private int evictionIdleSecs = -1;
    private boolean saveOnCreate;
    private boolean saveOnInactiveEviction;
    private boolean removeUnloadableSessions;

    public AbstractSessionCache(SessionHandler sessionHandler, SessionStore sessionStore, boolean clustered) {
        this.sessionHandler = sessionHandler;
        this.sessionStore = sessionStore;
        this.clustered = clustered && sessionStore != null;
    }

    protected SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    protected SessionStore getSessionStore() {
        return this.sessionStore;
    }

    @Override
    public boolean isClustered() {
        return this.clustered;
    }

    @Override
    public int getEvictionIdleSecs() {
        return this.evictionIdleSecs;
    }

    @Override
    public void setEvictionIdleSecs(int evictionTimeout) {
        this.evictionIdleSecs = evictionTimeout;
    }

    @Override
    public boolean isSaveOnCreate() {
        return this.saveOnCreate;
    }

    @Override
    public void setSaveOnCreate(boolean saveOnCreate) {
        this.saveOnCreate = saveOnCreate;
    }

    @Override
    public boolean isSaveOnInactiveEviction() {
        return this.saveOnInactiveEviction;
    }

    @Override
    public void setSaveOnInactiveEviction(boolean saveOnEvict) {
        this.saveOnInactiveEviction = saveOnEvict;
    }

    @Override
    public boolean isRemoveUnloadableSessions() {
        return this.removeUnloadableSessions;
    }

    @Override
    public void setRemoveUnloadableSessions(boolean removeUnloadableSessions) {
        this.removeUnloadableSessions = removeUnloadableSessions;
    }

    @Override
    public DefaultSession get(String id) throws Exception {
        AtomicBoolean resident = new AtomicBoolean(true);
        AtomicReference thrown = new AtomicReference();
        DefaultSession session = this.doComputeIfAbsent(id, k -> {
            if (log.isTraceEnabled()) {
                log.trace("Session " + id + " not found locally in " + this + ", attempting to load");
            }
            try {
                DefaultSession stored = this.loadSession((String)k);
                if (stored != null) {
                    try (Locker.Lock ignored = stored.lock();){
                        stored.setResident(true);
                    }
                    resident.set(false);
                } else if (log.isTraceEnabled()) {
                    log.trace("Session " + id + " not loaded by store");
                }
                return stored;
            }
            catch (Exception e) {
                thrown.set(e);
                return null;
            }
        });
        if (thrown.get() != null) {
            throw (Exception)thrown.get();
        }
        if (session != null) {
            try (Locker.Lock ignored = session.lock();){
                if (!session.isResident()) {
                    if (log.isTraceEnabled()) {
                        log.debug("Non-resident session " + id + " in cache");
                    }
                    DefaultSession defaultSession = null;
                    return defaultSession;
                }
                if (this.isClustered() && resident.get() && session.getRequests() <= 0L) {
                    DefaultSession stored = this.loadSession(id);
                    if (stored != null) {
                        boolean success = this.doReplace(id, session, stored);
                        if (!success) {
                            DefaultSession defaultSession = this.get(id);
                            return defaultSession;
                        }
                        session = stored;
                        session.setResident(true);
                    } else {
                        this.doDelete(id);
                        session.setResident(false);
                        session = null;
                    }
                }
            }
        }
        return session;
    }

    private DefaultSession loadSession(String id) throws Exception {
        if (this.sessionStore == null) {
            return null;
        }
        try {
            SessionData data = this.sessionStore.load(id);
            if (data == null) {
                return null;
            }
            return new DefaultSession(data, this.sessionHandler, false);
        }
        catch (UnreadableSessionDataException e) {
            if (this.isRemoveUnloadableSessions()) {
                this.sessionStore.delete(id);
            }
            throw e;
        }
    }

    @Override
    public DefaultSession add(String id, long time, long maxInactiveInterval) throws Exception {
        SessionData data;
        DefaultSession session;
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating new session id=" + id);
        }
        if (this.doPutIfAbsent(id, session = new DefaultSession(data = new SessionData(id, time, time, time, maxInactiveInterval), this.sessionHandler, true)) == null) {
            session.setResident(true);
            if (this.sessionStore != null && (this.isSaveOnCreate() || this.isClustered())) {
                this.sessionStore.save(id, data);
            }
            return session;
        }
        throw new IllegalStateException("Session " + id + " already in cache");
    }

    @Override
    public void release(String id, DefaultSession session) throws Exception {
        if (id == null || session == null) {
            throw new IllegalArgumentException("Put key=" + id + " session=" + (session == null ? "null" : session.getId()));
        }
        try (Locker.Lock ignored = session.lock();){
            if (!session.isValid()) {
                return;
            }
            if (this.sessionStore == null) {
                if (log.isTraceEnabled()) {
                    log.trace("Putting into SessionCache only id=" + id);
                }
                session.setResident(true);
                this.doPutIfAbsent(id, session);
                return;
            }
            if (session.getRequests() <= 0L) {
                this.sessionStore.save(id, session.getSessionData());
                if (this.getEvictionIdleSecs() == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Eviction on request exit id=" + id);
                    }
                    this.doDelete(session.getId());
                    session.setResident(false);
                } else {
                    session.setResident(true);
                    this.doPutIfAbsent(id, session);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Session " + id + " request=" + session.getRequests());
                }
                session.setResident(true);
                this.doPutIfAbsent(id, session);
            }
        }
    }

    @Override
    public boolean exists(String id) throws Exception {
        if (this.isClustered()) {
            DefaultSession ds = this.get(id);
            if (ds != null) {
                return ds.isValid();
            }
            return false;
        }
        DefaultSession ds = this.doGet(id);
        if (ds != null) {
            return ds.isValid();
        }
        return this.sessionStore != null && this.sessionStore.exists(id);
    }

    @Override
    public boolean contains(String id) throws Exception {
        return this.doGet(id) != null;
    }

    @Override
    public DefaultSession delete(String id) throws Exception {
        DefaultSession session = this.get(id);
        if (this.sessionStore != null) {
            boolean deleted = this.sessionStore.delete(id);
            if (log.isDebugEnabled()) {
                log.debug("Session " + id + " deleted in session data store: " + deleted);
            }
        }
        if (session != null) {
            session.setResident(false);
        }
        return this.doDelete(id);
    }

    protected abstract DefaultSession doGet(String var1);

    protected abstract DefaultSession doPutIfAbsent(String var1, DefaultSession var2);

    protected abstract DefaultSession doComputeIfAbsent(String var1, Function<String, DefaultSession> var2);

    protected abstract boolean doReplace(String var1, DefaultSession var2, DefaultSession var3);

    protected abstract DefaultSession doDelete(String var1);

    @Override
    public DefaultSession renewSessionId(String oldId, String newId) throws Exception {
        if (!StringUtils.hasText(oldId)) {
            throw new IllegalArgumentException("Old session id is null");
        }
        if (!StringUtils.hasText(oldId)) {
            throw new IllegalArgumentException("New session id is null");
        }
        DefaultSession session = this.get(oldId);
        this.renewSessionId(session, newId);
        return session;
    }

    protected void renewSessionId(DefaultSession session, String newId) throws Exception {
        if (session == null) {
            return;
        }
        try (Locker.Lock ignored = session.lock();){
            String oldId = session.getId();
            session.checkValidForWrite();
            session.getSessionData().setId(newId);
            session.getSessionData().setLastSavedTime(0L);
            session.getSessionData().setDirty(true);
            this.doPutIfAbsent(newId, session);
            this.doDelete(oldId);
            if (this.sessionStore != null) {
                this.sessionStore.delete(oldId);
                this.sessionStore.save(newId, session.getSessionData());
            }
            if (log.isDebugEnabled()) {
                log.debug("Session id " + oldId + " swapped for new id " + newId);
            }
        }
    }

    @Override
    public Set<String> checkExpiration(Set<String> candidates) {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.sessionStore == null) {
            return candidates;
        }
        if (log.isTraceEnabled()) {
            log.trace("SessionStore checking expiration on " + candidates);
        }
        Set<String> allCandidates = this.sessionStore.getExpired(candidates);
        HashSet<String> sessionsInUse = new HashSet<String>();
        if (allCandidates != null) {
            for (String c : allCandidates) {
                DefaultSession ds = this.doGet(c);
                if (ds == null || ds.getRequests() <= 0L) continue;
                sessionsInUse.add(c);
            }
            try {
                allCandidates.removeAll(sessionsInUse);
            }
            catch (UnsupportedOperationException e) {
                HashSet<String> tmp = new HashSet<String>(allCandidates);
                tmp.removeAll(sessionsInUse);
                allCandidates = tmp;
            }
        }
        return allCandidates;
    }

    @Override
    public void checkInactiveSession(DefaultSession session) {
        if (session == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Checking for idle " + session.getId());
        }
        try (Locker.Lock ignored = session.lock();){
            if (this.getEvictionIdleSecs() > 0 && session.isIdleLongerThan(this.getEvictionIdleSecs()) && session.isValid() && session.isResident() && session.getRequests() <= 0L) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Evicting idle session " + session.getId());
                    }
                    if (this.isSaveOnInactiveEviction() && this.sessionStore != null) {
                        this.sessionStore.save(session.getId(), session.getSessionData());
                    }
                    this.doDelete(session.getId());
                    session.setResident(false);
                }
                catch (Exception e) {
                    log.warn("Passivation of idle session" + session.getId() + " failed", e);
                }
            }
        }
    }
}

