/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.session.DefaultSession;
import com.aspectran.core.component.session.HouseKeeper;
import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionCache;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionIdGenerator;
import com.aspectran.core.component.session.SessionListener;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.statistic.SampleStatistic;
import com.aspectran.core.util.thread.Locker;
import com.aspectran.core.util.thread.ScheduledExecutorScheduler;
import com.aspectran.core.util.thread.Scheduler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractSessionHandler
extends AbstractComponent
implements SessionHandler {
    private static final Log log = LogFactory.getLog(AbstractSessionHandler.class);
    private final SampleStatistic sessionTimeStats = new SampleStatistic();
    private final List<SessionListener> sessionListeners = new CopyOnWriteArrayList<SessionListener>();
    private final Set<String> candidateSessionIdsForExpiry = ConcurrentHashMap.newKeySet();
    private final Scheduler scheduler = new ScheduledExecutorScheduler(String.format("session-scheduler-%x", this.hashCode()), false);
    private String workerName;
    private SessionIdGenerator sessionIdGenerator;
    private SessionCache sessionCache;
    private HouseKeeper houseKeeper;
    private volatile int defaultMaxIdleSecs = 1800;

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public String getWorkerName() {
        return this.workerName;
    }

    protected void setWorkerName(String workerName) {
        if (workerName != null && workerName.contains(".")) {
            throw new IllegalArgumentException("Worker name cannot contain '.'");
        }
        this.workerName = workerName;
    }

    @Override
    public SessionIdGenerator getSessionIdGenerator() {
        return this.sessionIdGenerator;
    }

    protected void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
    }

    @Override
    public SessionCache getSessionCache() {
        return this.sessionCache;
    }

    protected void setSessionCache(SessionCache sessionCache) {
        this.sessionCache = sessionCache;
    }

    public HouseKeeper getHouseKeeper() {
        return this.houseKeeper;
    }

    protected void setHouseKeeper(HouseKeeper houseKeeper) {
        this.houseKeeper = houseKeeper;
    }

    @Override
    public int getDefaultMaxIdleSecs() {
        return this.defaultMaxIdleSecs;
    }

    @Override
    public void setDefaultMaxIdleSecs(int defaultMaxIdleSecs) {
        this.defaultMaxIdleSecs = defaultMaxIdleSecs;
        if (log.isDebugEnabled()) {
            if (defaultMaxIdleSecs <= 0) {
                log.debug("Sessions created by this manager are immortal (default maxInactiveInterval=" + defaultMaxIdleSecs + ")");
            } else {
                log.debug("SessionHandler default maxInactiveInterval=" + defaultMaxIdleSecs);
            }
        }
    }

    @Override
    public DefaultSession getSession(String id) {
        try {
            DefaultSession session = this.sessionCache.get(id);
            if (session != null && session.isExpiredAt(System.currentTimeMillis())) {
                try {
                    session.setDestroyedReason(Session.DestroyedReason.TIMEOUT);
                    session.invalidate();
                }
                catch (Exception e) {
                    log.warn("Invalidating session " + id + " found to be expired when requested", e);
                }
                return null;
            }
            return session;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public DefaultSession createSession(String id) {
        long created = System.currentTimeMillis();
        long maxInactiveInterval = this.defaultMaxIdleSecs > 0 ? (long)this.defaultMaxIdleSecs * 1000L : -1L;
        try {
            DefaultSession session = this.sessionCache.add(id, created, maxInactiveInterval);
            this.fireSessionCreatedListeners(session);
            return session;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a new session", e);
        }
    }

    @Override
    public void releaseSession(DefaultSession session) {
        try {
            this.sessionCache.release(session.getId(), session);
        }
        catch (Exception e) {
            log.warn("Session failed to save", e);
        }
    }

    @Override
    public String createSessionId(long seedTerm) {
        return this.sessionIdGenerator.createSessionId(seedTerm);
    }

    @Override
    public String renewSessionId(String oldId, String newId) {
        try {
            DefaultSession session = this.sessionCache.renewSessionId(oldId, newId);
            for (SessionListener listener : this.sessionListeners) {
                listener.sessionIdChanged(session, oldId);
            }
            return session.getId();
        }
        catch (Exception e) {
            log.warn("Failed to renew session", e);
            return null;
        }
    }

    @Override
    public DefaultSession removeSession(String id, boolean invalidate) {
        return this.removeSession(id, invalidate, null);
    }

    @Override
    public DefaultSession removeSession(String id, boolean invalidate, Session.DestroyedReason reason) {
        if (!StringUtils.hasText(id)) {
            return null;
        }
        try {
            DefaultSession session;
            block9: {
                session = this.sessionCache.delete(id);
                if (invalidate && session != null) {
                    try {
                        if (!session.beginInvalidate()) break block9;
                        if (reason != null) {
                            session.setDestroyedReason(reason);
                        }
                        try {
                            this.fireSessionDestroyedListeners(session);
                        }
                        catch (Exception e) {
                            log.warn("Session listener threw exception", e);
                        }
                        session.finishInvalidate();
                    }
                    catch (IllegalStateException e) {
                        if (!log.isDebugEnabled()) break block9;
                        log.debug("Session " + session + " already invalid");
                    }
                }
            }
            return session;
        }
        catch (Exception e) {
            log.warn("Failed to invalidate session", e);
            return null;
        }
    }

    @Override
    public void invalidate(String id) {
        this.removeSession(id, true);
    }

    @Override
    public void invalidate(String id, Session.DestroyedReason reason) {
        this.removeSession(id, true, reason);
    }

    @Override
    public void sessionInactivityTimerExpired(DefaultSession session, long now) {
        if (session == null) {
            return;
        }
        try (Locker.Lock ignored = session.lock();){
            if (session.getRequests() > 0L) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("Inspecting session " + session.getId() + ", valid=" + session.isValid());
            }
            if (!session.isValid()) {
                if (log.isTraceEnabled()) {
                    log.trace("Session " + session.getId() + " is no longer valid");
                }
                return;
            }
            if (session.isExpiredAt(now)) {
                if (this.getHouseKeeper() != null && this.getHouseKeeper().isScavengable()) {
                    this.candidateSessionIdsForExpiry.add(session.getId());
                    if (log.isDebugEnabled()) {
                        log.debug("Session " + session.getId() + " is candidate for expiry");
                    }
                } else {
                    this.invalidate(session.getId(), Session.DestroyedReason.TIMEOUT);
                }
            } else {
                this.sessionCache.checkInactiveSession(session);
            }
        }
    }

    @Override
    public void scavenge() {
        if (this.isDestroying() || this.isDestroyed()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace(this.getComponentName() + " scavenging sessions");
        }
        String[] ss = this.candidateSessionIdsForExpiry.toArray(new String[0]);
        Set<String> candidates = new HashSet<String>(Arrays.asList(ss));
        this.candidateSessionIdsForExpiry.removeAll(candidates);
        if (log.isTraceEnabled()) {
            log.trace(this.getComponentName() + " scavenging session ids " + candidates);
        }
        try {
            candidates = this.sessionCache.checkExpiration(candidates);
            if (candidates != null) {
                for (String id : candidates) {
                    try {
                        this.invalidate(id, Session.DestroyedReason.TIMEOUT);
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage(), e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
    }

    @Override
    public void addSessionListener(SessionListener listener) {
        if (log.isDebugEnabled()) {
            log.debug("Registered session listener " + listener);
        }
        this.sessionListeners.add(listener);
    }

    @Override
    public void removeSessionListener(SessionListener listener) {
        if (log.isDebugEnabled()) {
            log.debug("Removed session listener " + listener);
        }
        this.sessionListeners.remove(listener);
    }

    @Override
    public void clearSessionListeners() {
        this.sessionListeners.clear();
    }

    @Override
    public void fireSessionAttributeListeners(Session session, String name, Object oldValue, Object newValue) {
        if (session == null) {
            return;
        }
        for (SessionListener listener : this.sessionListeners) {
            if (oldValue == null) {
                listener.attributeAdded(session, name, newValue);
                continue;
            }
            if (newValue == null) {
                listener.attributeRemoved(session, name, oldValue);
                continue;
            }
            listener.attributeUpdated(session, name, newValue, oldValue);
        }
    }

    @Override
    public void fireSessionDestroyedListeners(Session session) {
        if (session == null) {
            return;
        }
        if (!this.sessionListeners.isEmpty()) {
            ArrayList<SessionListener> listeners = new ArrayList<SessionListener>(this.sessionListeners);
            ListIterator iter = listeners.listIterator(listeners.size());
            while (iter.hasPrevious()) {
                ((SessionListener)iter.previous()).sessionDestroyed(session);
            }
        }
    }

    private void fireSessionCreatedListeners(Session session) {
        if (session == null) {
            return;
        }
        for (SessionListener listener : this.sessionListeners) {
            listener.sessionCreated(session);
        }
    }

    @Override
    public void recordSessionTime(DefaultSession session) {
        this.sessionTimeStats.record(Math.round((double)(System.currentTimeMillis() - session.getSessionData().getCreationTime()) / 1000.0));
    }

    @Override
    public long getSessionTimeMax() {
        return this.sessionTimeStats.getMax();
    }

    @Override
    public long getSessionTimeTotal() {
        return this.sessionTimeStats.getTotal();
    }

    @Override
    public long getSessionTimeMean() {
        return Math.round(this.sessionTimeStats.getMean());
    }

    @Override
    public double getSessionTimeStdDev() {
        return this.sessionTimeStats.getStdDev();
    }

    @Override
    public void statsReset() {
        this.sessionTimeStats.reset();
    }

    @Override
    protected void doInitialize() throws Exception {
        this.scheduler.start();
        if (this.houseKeeper != null) {
            this.houseKeeper.startScavenging();
        }
    }

    @Override
    protected void doDestroy() throws Exception {
        if (this.houseKeeper != null) {
            this.houseKeeper.stopScavenging();
        }
        this.scheduler.stop();
        this.sessionCache.destroy();
    }

    @Override
    public String getComponentName() {
        if (this.workerName != null) {
            return super.getComponentName() + "(" + this.workerName + ")";
        }
        return super.getComponentName();
    }
}

