/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.builder.reload;

import com.aspectran.core.context.builder.reload.ActivityContextReloadTask;
import com.aspectran.core.service.ServiceController;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.net.URL;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;

public class ActivityContextReloader {
    private static final Log log = LogFactory.getLog(ActivityContextReloader.class);
    private final ServiceController serviceController;
    private Enumeration<URL> resources;
    private volatile Timer timer;
    private ActivityContextReloadTask reloadTask;

    public ActivityContextReloader(ServiceController serviceController) {
        this.serviceController = serviceController;
    }

    public void setResources(Enumeration<URL> resources) {
        this.resources = resources;
        if (log.isDebugEnabled()) {
            log.debug("ActivityContextReloader is initialized");
        }
    }

    public void start(int scanIntervalInSeconds) {
        this.stop();
        if (log.isDebugEnabled()) {
            log.debug("Starting ActivityContextReloader...");
        }
        this.reloadTask = new ActivityContextReloadTask(this.serviceController);
        this.reloadTask.setResources(this.resources);
        this.timer = new Timer("ContextReloadTask@" + this.reloadTask.hashCode());
        this.timer.schedule((TimerTask)this.reloadTask, 0L, (long)scanIntervalInSeconds * 1000L);
    }

    public void stop() {
        if (this.timer != null) {
            if (log.isDebugEnabled()) {
                log.debug("Stopping ActivityContextReloader...");
            }
            this.timer.cancel();
            this.timer = null;
            this.reloadTask.cancel();
            this.reloadTask = null;
        }
    }
}

