/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.expr.token;

import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.rule.type.TokenDirectiveType;
import com.aspectran.core.context.rule.type.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Tokenizer {
    private static final int MAX_TOKEN_NAME_LENGTH = 256;
    private static final int AT_TEXT = 1;
    private static final int AT_TOKEN_SYMBOL = 2;
    private static final int AT_TOKEN_NAME = 3;
    private static final int AT_TOKEN_VALUE = 4;
    private static final char CR = '\r';
    private static final char LF = '\n';

    public static List<Token> tokenize(CharSequence input, boolean textTrim) {
        Token token;
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        int inputLen = input.length();
        if (inputLen == 0) {
            ArrayList<Token> tokens = new ArrayList<Token>(1);
            tokens.add(new Token(""));
            return tokens;
        }
        int status = 1;
        int tokenStartOffset = 0;
        char symbol = '$';
        StringBuilder nameBuf = new StringBuilder();
        StringBuilder valueBuf = new StringBuilder();
        StringBuilder textBuf = new StringBuilder();
        ArrayList<Token> tokens = new ArrayList<Token>();
        block5: for (int i = 0; i < inputLen; ++i) {
            char c = input.charAt(i);
            switch (status) {
                case 1: {
                    textBuf.append(c);
                    if (!Token.isTokenSymbol(c)) continue block5;
                    symbol = c;
                    status = 2;
                    tokenStartOffset = textBuf.length() - 1;
                    continue block5;
                }
                case 2: {
                    textBuf.append(c);
                    if (c == '{') {
                        status = 3;
                        continue block5;
                    }
                    if (Token.isTokenSymbol(c)) {
                        symbol = c;
                        status = 2;
                        tokenStartOffset = textBuf.length() - 1;
                        continue block5;
                    }
                    status = 1;
                    continue block5;
                }
                case 3: 
                case 4: {
                    textBuf.append(c);
                    if (status == 3 && c == ':') {
                        status = 4;
                        continue block5;
                    }
                    if (c == '}') {
                        if (nameBuf.length() > 0 || valueBuf.length() > 0) {
                            if (tokenStartOffset > 0) {
                                String text = Tokenizer.trimBuffer(textBuf, tokenStartOffset, textTrim);
                                Token token2 = new Token(text);
                                tokens.add(token2);
                            }
                            token = Tokenizer.createToken(symbol, nameBuf, valueBuf);
                            tokens.add(token);
                            status = 1;
                            textBuf.setLength(0);
                            continue block5;
                        }
                        status = 1;
                        continue block5;
                    }
                    if (status == 3) {
                        if (nameBuf.length() > 256) {
                            status = 1;
                            nameBuf.setLength(0);
                        }
                        nameBuf.append(c);
                        continue block5;
                    }
                    valueBuf.append(c);
                }
            }
        }
        if (textBuf.length() > 0) {
            String text = Tokenizer.trimBuffer(textBuf, textBuf.length(), textTrim);
            token = new Token(text);
            tokens.add(token);
        }
        return tokens;
    }

    private static Token createToken(char symbol, StringBuilder nameBuf, StringBuilder valueBuf) {
        String value = null;
        if (valueBuf.length() > 0) {
            value = valueBuf.toString();
            valueBuf.setLength(0);
        }
        if (nameBuf.length() > 0) {
            TokenType type = Token.resolveTypeAsSymbol(symbol);
            String name = nameBuf.toString();
            nameBuf.setLength(0);
            int offset = name.indexOf(94);
            if (offset > -1) {
                String name2 = name.substring(0, offset);
                String getter = name.substring(offset + 1);
                Token token = new Token(type, name2);
                if (!getter.isEmpty()) {
                    token.setGetterName(getter);
                }
                token.setDefaultValue(value);
                return token;
            }
            if (value != null) {
                TokenDirectiveType directiveType = TokenDirectiveType.resolve(name);
                if (directiveType != null) {
                    String getter = null;
                    String defaultValue = null;
                    offset = value.indexOf(94);
                    if (offset > -1) {
                        String value2 = value.substring(0, offset);
                        String getter2 = value.substring(offset + 1);
                        value = value2;
                        offset = getter2.indexOf(58);
                        if (offset > -1) {
                            String getter3 = getter2.substring(0, offset);
                            String value3 = getter2.substring(offset + 1);
                            if (!getter3.isEmpty()) {
                                getter = getter3;
                            }
                            if (!value3.isEmpty()) {
                                defaultValue = value3;
                            }
                        } else if (!getter2.isEmpty()) {
                            getter = getter2;
                        }
                    }
                    Token token = new Token(type, directiveType, value);
                    token.setGetterName(getter);
                    token.setDefaultValue(defaultValue);
                    return token;
                }
                Token token = new Token(type, name);
                token.setDefaultValue(value);
                return token;
            }
            return new Token(type, name);
        }
        return new Token(value);
    }

    private static String trimBuffer(StringBuilder textBuf, int end, boolean trim) {
        char c;
        int i;
        if (!trim) {
            return textBuf.substring(0, end);
        }
        int start = 0;
        boolean leadingLF = false;
        boolean tailingLF = false;
        for (i = 0; i < end; ++i) {
            c = textBuf.charAt(i);
            if (c == '\n' || c == '\r') {
                leadingLF = true;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            start = i;
            break;
        }
        if (leadingLF && start == 0) {
            return String.valueOf('\n');
        }
        for (i = end - 1; i > start; --i) {
            c = textBuf.charAt(i);
            if (c == '\n' || c == '\r') {
                tailingLF = true;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            end = i + 1;
            break;
        }
        if (leadingLF) {
            textBuf.setCharAt(--start, '\n');
        }
        if (tailingLF) {
            textBuf.setCharAt(end++, '\n');
        }
        return textBuf.substring(start, end);
    }

    public static Token[] optimize(Token[] tokens) {
        String text;
        if (tokens == null) {
            return null;
        }
        String firstVal = null;
        String lastVal = null;
        if (tokens.length == 1) {
            if (tokens[0].getType() == TokenType.TEXT) {
                firstVal = tokens[0].getDefaultValue();
            }
        } else if (tokens.length > 1) {
            if (tokens[0].getType() == TokenType.TEXT) {
                firstVal = tokens[0].getDefaultValue();
            }
            if (tokens[tokens.length - 1].getType() == TokenType.TEXT) {
                lastVal = tokens[tokens.length - 1].getDefaultValue();
            }
        }
        if (firstVal != null && !Objects.equals(firstVal, text = Tokenizer.trimLeadingWhitespace(firstVal))) {
            tokens[0] = new Token(text);
        }
        if (lastVal != null && !lastVal.isEmpty() && !Objects.equals(lastVal, text = Tokenizer.trimTrailingWhitespace(lastVal))) {
            tokens[tokens.length - 1] = new Token(text);
        }
        return tokens;
    }

    private static String trimLeadingWhitespace(String string) {
        if (string.isEmpty()) {
            return string;
        }
        int start = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            start = i;
            break;
        }
        if (start == 0) {
            return string;
        }
        return string.substring(start);
    }

    private static String trimTrailingWhitespace(String string) {
        int end = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            end = i;
            break;
        }
        if (end == 0) {
            return string;
        }
        return string.substring(0, end + 1);
    }
}

