/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.core.context.rule.type.PointcutType;
import com.aspectran.core.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.List;

public class PointcutRule {
    private final PointcutType pointcutType;
    private List<PointcutPatternRule> pointcutPatternRuleList;

    public PointcutRule(PointcutType pointcutType) {
        this.pointcutType = pointcutType;
    }

    public PointcutType getPointcutType() {
        return this.pointcutType;
    }

    public List<PointcutPatternRule> getPointcutPatternRuleList() {
        return this.pointcutPatternRuleList;
    }

    public void setPointcutPatternRuleList(List<PointcutPatternRule> pointcutPatternRuleList) {
        this.pointcutPatternRuleList = pointcutPatternRuleList;
    }

    public void addPointcutPatternRule(PointcutPatternRule pointcutPatternRule) {
        pointcutPatternRule.setPointcutType(this.pointcutType);
        this.touchPointcutPatternRuleList().add(pointcutPatternRule);
    }

    public List<PointcutPatternRule> touchPointcutPatternRuleList() {
        if (this.pointcutPatternRuleList == null) {
            this.newPointcutPatternRuleList();
        }
        return this.pointcutPatternRuleList;
    }

    public List<PointcutPatternRule> newPointcutPatternRuleList() {
        this.pointcutPatternRuleList = new ArrayList<PointcutPatternRule>();
        return this.pointcutPatternRuleList;
    }

    public List<PointcutPatternRule> newPointcutPatternRuleList(int initialCapacity) {
        this.pointcutPatternRuleList = new ArrayList<PointcutPatternRule>(initialCapacity);
        return this.pointcutPatternRuleList;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("type", (Object)this.pointcutType);
        tsb.append("patterns", this.pointcutPatternRuleList);
        return tsb.toString();
    }

    public static PointcutRule newInstance(String type) throws IllegalRuleException {
        PointcutType pointcutType = null;
        if (type != null && (pointcutType = PointcutType.resolve(type)) == null) {
            throw new IllegalRuleException("Unrecognized pointcut type '" + type + "'; Pointcut type for Translet must be 'wildcard' or 'regexp'");
        }
        return new PointcutRule(pointcutType);
    }

    public static PointcutRule newInstance(String[] patterns) {
        PointcutRule pointcutRule = new PointcutRule(PointcutType.WILDCARD);
        List<PointcutPatternRule> pointcutPatternRuleList = pointcutRule.newPointcutPatternRuleList();
        List<PointcutPatternRule> excludePointcutPatternRuleList = pointcutRule.newPointcutPatternRuleList();
        for (String pattern : patterns) {
            PointcutPatternRule pointcutPatternRule;
            if (pattern == null) continue;
            if ((pattern = pattern.trim()).startsWith("-")) {
                pattern = pattern.startsWith("-:") ? pattern.substring(2).trim() : pattern.substring(1).trim();
                pointcutPatternRule = PointcutPatternRule.parsePattern(pattern);
                excludePointcutPatternRuleList.add(pointcutPatternRule);
                continue;
            }
            if (pattern.startsWith("+:")) {
                pattern = pattern.substring(2).trim();
            } else if (pattern.startsWith("+")) {
                pattern = pattern.substring(1).trim();
            }
            pointcutPatternRule = PointcutPatternRule.parsePattern(pattern);
            pointcutPatternRuleList.add(pointcutPatternRule);
        }
        for (PointcutPatternRule pointcutPatternRule : pointcutPatternRuleList) {
            pointcutPatternRule.setPointcutType(pointcutRule.getPointcutType());
            if (excludePointcutPatternRuleList.isEmpty()) continue;
            pointcutPatternRule.setExcludePointcutPatternRuleList(excludePointcutPatternRuleList);
        }
        pointcutRule.setPointcutPatternRuleList(pointcutPatternRuleList);
        return pointcutRule;
    }
}

