/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.appender;

import com.aspectran.core.context.env.ContextEnvironment;
import com.aspectran.core.context.rule.AppendRule;
import com.aspectran.core.context.rule.appender.AbstractRuleAppender;
import com.aspectran.core.context.rule.appender.FileRuleAppender;
import com.aspectran.core.context.rule.appender.ParametersRuleAppender;
import com.aspectran.core.context.rule.appender.ResourceRuleAppender;
import com.aspectran.core.context.rule.appender.RuleAppendHandler;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.appender.UrlRuleAppender;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractAppendHandler
implements RuleAppendHandler {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final ContextRuleAssistant assistant;
    private final ContextEnvironment environment;
    private List<RuleAppender> pendingList;
    private RuleAppender currentRuleAppender;
    private boolean useAponToLoadXml;
    private boolean debugMode;

    AbstractAppendHandler(ContextRuleAssistant assistant) {
        this.assistant = assistant;
        this.environment = assistant.getContextEnvironment();
    }

    @Override
    public ContextRuleAssistant getContextRuleAssistant() {
        return this.assistant;
    }

    @Override
    public void pending(AppendRule appendRule) {
        AbstractRuleAppender appender = null;
        if (appendRule.getAspectranParameters() != null) {
            appender = new ParametersRuleAppender();
        } else if (StringUtils.hasText(appendRule.getFile())) {
            appender = new FileRuleAppender(this.assistant.getBasePath(), appendRule.getFile());
        } else if (StringUtils.hasText(appendRule.getResource())) {
            appender = new ResourceRuleAppender(appendRule.getResource(), this.assistant.getClassLoader());
        } else if (StringUtils.hasText(appendRule.getUrl())) {
            appender = new UrlRuleAppender(appendRule.getUrl());
        }
        if (appender != null) {
            appender.setAppendRule(appendRule);
            this.pending(appender);
        }
    }

    private void pending(RuleAppender appender) {
        if (this.pendingList == null) {
            this.pendingList = new ArrayList<RuleAppender>();
        }
        this.pendingList.add(appender);
        if (this.log.isTraceEnabled()) {
            this.log.trace("pending RuleAppender " + appender);
        }
    }

    protected void handle() throws Exception {
        block6: {
            if (this.pendingList == null) break block6;
            List<RuleAppender> pendedList = this.pendingList;
            this.pendingList = null;
            if (this.environment != null) {
                for (RuleAppender appender : pendedList) {
                    if (!this.environment.acceptsProfiles(appender.getProfiles())) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Append " + appender);
                    }
                    this.handle(appender);
                }
            } else {
                for (RuleAppender appender : pendedList) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Append " + appender);
                    }
                    this.handle(appender);
                }
            }
        }
    }

    @Override
    public List<RuleAppender> getPendingList() {
        return this.pendingList;
    }

    @Override
    public RuleAppender getCurrentRuleAppender() {
        return this.currentRuleAppender;
    }

    @Override
    public void setCurrentRuleAppender(RuleAppender currentRuleAppender) {
        this.currentRuleAppender = currentRuleAppender;
    }

    protected boolean isUseAponToLoadXml() {
        return this.useAponToLoadXml;
    }

    @Override
    public void setUseAponToLoadXml(boolean useAponToLoadXml) {
        this.useAponToLoadXml = useAponToLoadXml;
    }

    protected boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }
}

