/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.params;

import com.aspectran.core.context.rule.AppendRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.EnvironmentRule;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.converter.RulesToParameters;
import com.aspectran.core.context.rule.params.AppendParameters;
import com.aspectran.core.context.rule.params.AspectParameters;
import com.aspectran.core.context.rule.params.BeanParameters;
import com.aspectran.core.context.rule.params.DescriptionParameters;
import com.aspectran.core.context.rule.params.EnvironmentParameters;
import com.aspectran.core.context.rule.params.ScheduleParameters;
import com.aspectran.core.context.rule.params.SettingsParameters;
import com.aspectran.core.context.rule.params.TemplateParameters;
import com.aspectran.core.context.rule.params.TransletParameters;
import com.aspectran.core.context.rule.params.TypeAliasesParameters;
import com.aspectran.core.context.rule.type.DefaultSettingType;
import com.aspectran.core.util.apon.AbstractParameters;
import com.aspectran.core.util.apon.ParameterKey;

public class AspectranParameters
extends AbstractParameters {
    public static final ParameterKey description = new ParameterKey("description", DescriptionParameters.class, true, true);
    public static final ParameterKey settings = new ParameterKey("settings", SettingsParameters.class);
    public static final ParameterKey environment;
    public static final ParameterKey typeAliases;
    public static final ParameterKey aspect;
    public static final ParameterKey bean;
    public static final ParameterKey schedule;
    public static final ParameterKey translet;
    public static final ParameterKey template;
    public static final ParameterKey append;
    private static final ParameterKey[] parameterKeys;

    public AspectranParameters() {
        super(parameterKeys);
    }

    public AspectranParameters setTransletNamePrefix(String prefixPattern) {
        return this.setSetting(DefaultSettingType.TRANSLET_NAME_PREFIX, prefixPattern);
    }

    public AspectranParameters setTransletNameSuffix(String suffixPattern) {
        return this.setSetting(DefaultSettingType.TRANSLET_NAME_SUFFIX, suffixPattern);
    }

    public AspectranParameters setBeanProxifier(String proxifierName) {
        return this.setSetting(DefaultSettingType.BEAN_PROXIFIER, proxifierName);
    }

    public AspectranParameters setPointcutPatternVerifiable(boolean verifiable) {
        return this.setSetting(DefaultSettingType.POINTCUT_PATTERN_VERIFIABLE, verifiable);
    }

    public AspectranParameters setDefaultTemplateEngineBean(String beanName) {
        return this.setSetting(DefaultSettingType.DEFAULT_TEMPLATE_ENGINE_BEAN, beanName);
    }

    public AspectranParameters setDefaultSchedulerBean(String beanName) {
        return this.setSetting(DefaultSettingType.DEFAULT_SCHEDULER_BEAN, beanName);
    }

    private AspectranParameters setSetting(DefaultSettingType defaultSettingType, Object value) {
        SettingsParameters settingsParameters = (SettingsParameters)this.touchParameters(settings);
        settingsParameters.putSetting(defaultSettingType.toString(), value);
        return this;
    }

    public AspectranParameters addTypeAlias(String alias, String type) {
        TypeAliasesParameters typeAliasesParameters = (TypeAliasesParameters)this.touchParameters(typeAliases);
        Object parameters = typeAliasesParameters.touchParameters(TypeAliasesParameters.typeAlias);
        parameters.clearValue(alias);
        parameters.putValue(alias, (Object)type);
        return this;
    }

    public AspectranParameters addRule(DescriptionRule descriptionRule) {
        RulesToParameters.toDescriptionParameters(descriptionRule, this, description);
        return this;
    }

    public AspectranParameters addRule(EnvironmentRule environmentRule) {
        this.putValue(environment, (Object)RulesToParameters.toEnvironmentParameters(environmentRule));
        return this;
    }

    public AspectranParameters addRule(AspectRule aspectRule) {
        this.putValue(aspect, (Object)RulesToParameters.toAspectParameters(aspectRule));
        return this;
    }

    public AspectranParameters addRule(BeanRule beanRule) {
        this.putValue(bean, (Object)RulesToParameters.toBeanParameters(beanRule));
        return this;
    }

    public AspectranParameters addRule(ScheduleRule scheduleRule) {
        this.putValue(schedule, (Object)RulesToParameters.toScheduleParameters(scheduleRule));
        return this;
    }

    public AspectranParameters addRule(TransletRule transletRule) {
        this.putValue(translet, (Object)RulesToParameters.toTransletParameters(transletRule));
        return this;
    }

    public AspectranParameters addRule(TemplateRule templateRule) {
        this.putValue(template, (Object)RulesToParameters.toTemplateParameters(templateRule));
        return this;
    }

    public AspectranParameters addRule(AppendRule appendRule) {
        this.putValue(append, (Object)RulesToParameters.toAppendParameters(appendRule));
        return this;
    }

    public AspectranParameters append(AspectranParameters aspectranParameters) {
        return this.append(aspectranParameters, null);
    }

    public AspectranParameters append(AspectranParameters aspectranParameters, String profile) {
        AppendParameters appendParameters = new AppendParameters();
        appendParameters.putValue(AppendParameters.aspectran, (Object)aspectranParameters);
        if (profile != null && !profile.isEmpty()) {
            appendParameters.putValue(AppendParameters.profile, (Object)profile);
        }
        this.putValue(append, (Object)appendParameters);
        return this;
    }

    public AspectranParameters newAspectranParameters() {
        return this.newAspectranParameters(null);
    }

    public AspectranParameters newAspectranParameters(String profile) {
        AspectranParameters aspectranParameters = new AspectranParameters();
        this.append(aspectranParameters, profile);
        return aspectranParameters;
    }

    static {
        typeAliases = new ParameterKey("typeAliases", TypeAliasesParameters.class);
        environment = new ParameterKey("environment", EnvironmentParameters.class, true, true);
        aspect = new ParameterKey("aspect", AspectParameters.class, true, true);
        bean = new ParameterKey("bean", BeanParameters.class, true, true);
        schedule = new ParameterKey("schedule", ScheduleParameters.class, true, true);
        translet = new ParameterKey("translet", TransletParameters.class, true, true);
        template = new ParameterKey("template", TemplateParameters.class, true, true);
        append = new ParameterKey("append", AppendParameters.class, true, true);
        parameterKeys = new ParameterKey[]{description, settings, typeAliases, environment, aspect, bean, schedule, translet, template, append};
    }
}

