/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.ContentList;
import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.RequestRule;
import com.aspectran.core.context.rule.ResponseRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.nodelet.NodeletAdder;
import com.aspectran.core.util.nodelet.NodeletParser;

class TransletNodeletAdder
implements NodeletAdder {
    TransletNodeletAdder() {
    }

    @Override
    public void add(String xpath, NodeletParser parser) {
        AspectranNodeParser nodeParser = (AspectranNodeParser)parser.getNodeParser();
        ContextRuleAssistant assistant = nodeParser.getAssistant();
        parser.setXpath(xpath + "/translet");
        parser.addNodelet(attrs -> {
            String name = (String)attrs.get("name");
            String scan = (String)attrs.get("scan");
            String mask = (String)attrs.get("mask");
            String method = (String)attrs.get("method");
            TransletRule transletRule = TransletRule.newInstance(name, scan, mask, method);
            parser.pushObject(transletRule);
        });
        parser.addNodeEndlet(text -> {
            TransletRule transletRule = (TransletRule)parser.popObject();
            assistant.addTransletRule(transletRule);
        });
        parser.setXpath(xpath + "/translet/description");
        parser.addNodelet(attrs -> {
            String profile = (String)attrs.get("profile");
            String style = (String)attrs.get("style");
            DescriptionRule descriptionRule = DescriptionRule.newInstance(profile, style);
            parser.pushObject(descriptionRule);
        });
        parser.addNodeEndlet(text -> {
            DescriptionRule descriptionRule = (DescriptionRule)parser.popObject();
            TransletRule transletRule = (TransletRule)parser.peekObject();
            descriptionRule.setContent(text);
            descriptionRule = assistant.profiling(descriptionRule, transletRule.getDescriptionRule());
            transletRule.setDescriptionRule(descriptionRule);
        });
        parser.setXpath(xpath + "/translet/parameters");
        parser.addNodelet(attrs -> {
            ItemRuleMap irm = new ItemRuleMap();
            irm.setProfile(StringUtils.emptyToNull((String)attrs.get("profile")));
            parser.pushObject(irm);
        });
        nodeParser.addItemNodelets();
        parser.addNodeEndlet(text -> {
            ItemRuleMap irm = (ItemRuleMap)parser.popObject();
            TransletRule transletRule = (TransletRule)parser.peekObject();
            RequestRule requestRule = transletRule.touchRequestRule(false);
            irm = assistant.profiling(irm, requestRule.getParameterItemRuleMap());
            requestRule.setParameterItemRuleMap(irm);
        });
        parser.setXpath(xpath + "/translet/attributes");
        parser.addNodelet(attrs -> {
            ItemRuleMap irm = new ItemRuleMap();
            irm.setProfile(StringUtils.emptyToNull((String)attrs.get("profile")));
            parser.pushObject(irm);
        });
        nodeParser.addItemNodelets();
        parser.addNodeEndlet(text -> {
            ItemRuleMap irm = (ItemRuleMap)parser.popObject();
            TransletRule transletRule = (TransletRule)parser.peekObject();
            RequestRule requestRule = transletRule.touchRequestRule(false);
            irm = assistant.profiling(irm, requestRule.getAttributeItemRuleMap());
            requestRule.setAttributeItemRuleMap(irm);
        });
        parser.setXpath(xpath + "/translet/request");
        parser.addNodelet(attrs -> {
            String method = (String)attrs.get("method");
            String encoding = (String)attrs.get("encoding");
            RequestRule requestRule = RequestRule.newInstance(method, encoding);
            parser.pushObject(requestRule);
        });
        parser.addNodeEndlet(text -> {
            RequestRule requestRule = (RequestRule)parser.popObject();
            TransletRule transletRule = (TransletRule)parser.peekObject();
            transletRule.setRequestRule(requestRule);
        });
        parser.setXpath(xpath + "/translet/request/parameters");
        parser.addNodelet(attrs -> {
            ItemRuleMap irm = new ItemRuleMap();
            irm.setProfile(StringUtils.emptyToNull((String)attrs.get("profile")));
            parser.pushObject(irm);
        });
        nodeParser.addItemNodelets();
        parser.addNodeEndlet(text -> {
            ItemRuleMap irm = (ItemRuleMap)parser.popObject();
            RequestRule requestRule = (RequestRule)parser.peekObject();
            irm = assistant.profiling(irm, requestRule.getParameterItemRuleMap());
            requestRule.setParameterItemRuleMap(irm);
        });
        parser.setXpath(xpath + "/translet/request/attributes");
        parser.addNodelet(attrs -> {
            ItemRuleMap irm = new ItemRuleMap();
            irm.setProfile(StringUtils.emptyToNull((String)attrs.get("profile")));
            parser.pushObject(irm);
        });
        nodeParser.addItemNodelets();
        parser.addNodeEndlet(text -> {
            ItemRuleMap irm = (ItemRuleMap)parser.popObject();
            RequestRule requestRule = (RequestRule)parser.peekObject();
            irm = assistant.profiling(irm, requestRule.getAttributeItemRuleMap());
            requestRule.setAttributeItemRuleMap(irm);
        });
        parser.setXpath(xpath + "/translet");
        nodeParser.addNestedActionNodelets();
        parser.setXpath(xpath + "/translet/contents");
        parser.addNodelet(attrs -> {
            String name = (String)attrs.get("name");
            ContentList contentList = ContentList.newInstance(name);
            parser.pushObject(contentList);
        });
        parser.addNodeEndlet(text -> {
            ContentList contentList = (ContentList)parser.popObject();
            if (!contentList.isEmpty()) {
                TransletRule transletRule = (TransletRule)parser.peekObject();
                transletRule.setContentList(contentList);
            }
        });
        parser.setXpath(xpath + "/translet/contents/content");
        parser.addNodelet(attrs -> {
            String name = (String)attrs.get("name");
            ActionList actionList = ActionList.newInstance(name);
            parser.pushObject(actionList);
        });
        nodeParser.addNestedActionNodelets();
        parser.addNodeEndlet(text -> {
            ActionList actionList = (ActionList)parser.popObject();
            if (!actionList.isEmpty()) {
                ContentList contentList = (ContentList)parser.peekObject();
                contentList.addActionList(actionList);
            }
        });
        parser.setXpath(xpath + "/translet/content");
        parser.addNodelet(attrs -> {
            String name = (String)attrs.get("name");
            ActionList actionList = ActionList.newInstance(name);
            parser.pushObject(actionList);
        });
        nodeParser.addNestedActionNodelets();
        parser.addNodeEndlet(text -> {
            ActionList actionList = (ActionList)parser.popObject();
            if (!actionList.isEmpty()) {
                ContentList contentList = new ContentList(false);
                contentList.add(actionList);
                TransletRule transletRule = (TransletRule)parser.peekObject();
                transletRule.setContentList(contentList);
            }
        });
        parser.setXpath(xpath + "/translet");
        nodeParser.addResponseInnerNodelets();
        parser.setXpath(xpath + "/translet/response");
        parser.addNodelet(attrs -> {
            String name = (String)attrs.get("name");
            String encoding = (String)attrs.get("encoding");
            ResponseRule responseRule = ResponseRule.newInstance(name, encoding);
            parser.pushObject(responseRule);
        });
        nodeParser.addNestedActionNodelets();
        nodeParser.addResponseInnerNodelets();
        parser.addNodeEndlet(text -> {
            ResponseRule responseRule = (ResponseRule)parser.popObject();
            TransletRule transletRule = (TransletRule)parser.peekObject();
            transletRule.addResponseRule(responseRule);
        });
        parser.setXpath(xpath + "/translet/exception");
        parser.addNodelet(attrs -> {
            ExceptionRule exceptionRule = new ExceptionRule();
            parser.pushObject(exceptionRule);
        });
        nodeParser.addExceptionInnerNodelets();
        parser.addNodeEndlet(text -> {
            ExceptionRule exceptionRule = (ExceptionRule)parser.popObject();
            TransletRule transletRule = (TransletRule)parser.peekObject();
            transletRule.setExceptionRule(exceptionRule);
        });
    }
}

