/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.type;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public enum MethodType {
    GET,
    POST,
    PUT,
    PATCH,
    DELETE,
    HEAD,
    OPTIONS,
    TRACE;

    private static final int MAX_COUNT = 8;
    private static final Map<String, MethodType> mappings;

    public boolean containsTo(MethodType[] types) {
        if (types != null) {
            for (MethodType type : types) {
                if (!this.equals((Object)type)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(String type) {
        return this.name().equals(type);
    }

    public static MethodType resolve(String methodType) {
        return methodType != null ? mappings.get(methodType.toUpperCase()) : null;
    }

    public static MethodType[] parse(String value) {
        MethodType[] types = new MethodType[8];
        int count = 0;
        StringTokenizer st = new StringTokenizer(value, ", ");
        while (st.hasMoreTokens()) {
            int ord;
            MethodType type;
            String token = st.nextToken();
            if (token.isEmpty() || (type = MethodType.resolve(token)) == null || types[ord = type.ordinal()] != null) continue;
            types[ord] = type;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        MethodType[] orderedTypes = new MethodType[count];
        int seq = 0;
        for (int i = 0; i < 8; ++i) {
            if (types[i] == null) continue;
            orderedTypes[seq++] = types[i];
        }
        return orderedTypes;
    }

    public static String stringify(MethodType[] types) {
        if (types == null || types.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(types.length * 7 + 1);
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append((Object)types[i]);
        }
        return sb.toString();
    }

    static {
        mappings = new HashMap<String, MethodType>();
        for (MethodType type : MethodType.values()) {
            mappings.put(type.name(), type);
        }
    }
}

