/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.support.i18n.locale;

import com.aspectran.core.activity.Translet;
import com.aspectran.core.support.i18n.locale.LocaleResolver;
import com.aspectran.core.util.StringUtils;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AbstractLocaleResolver
implements LocaleResolver {
    private Locale defaultLocale;
    private TimeZone defaultTimeZone;

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.setDefaultLocale(StringUtils.parseLocaleString(defaultLocale));
    }

    public TimeZone getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    public void setDefaultTimeZone(TimeZone defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
    }

    public void setDefaultTimeZone(String defaultTimeZone) {
        this.setDefaultTimeZone(StringUtils.parseTimeZoneString(defaultTimeZone));
    }

    protected Locale resolveDefaultLocale(Translet translet) {
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale != null) {
            translet.getRequestAdapter().setLocale(defaultLocale);
            return defaultLocale;
        }
        return translet.getRequestAdapter().getLocale();
    }

    protected TimeZone resolveDefaultTimeZone(Translet translet) {
        TimeZone defaultTimeZone = this.getDefaultTimeZone();
        if (defaultTimeZone != null) {
            translet.getRequestAdapter().setTimeZone(defaultTimeZone);
            return defaultTimeZone;
        }
        return translet.getRequestAdapter().getTimeZone();
    }

    @Override
    public void setLocale(Translet translet, Locale locale) {
        translet.getRequestAdapter().setLocale(locale);
    }

    @Override
    public void setTimeZone(Translet translet, TimeZone timeZone) {
        translet.getRequestAdapter().setTimeZone(timeZone);
    }
}

