/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.ConcurrentReferenceHashMap;
import com.aspectran.core.util.ReflectionUtils;
import com.aspectran.core.util.TypeUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;

public class MethodUtils {
    public static final Class<?>[] EMPTY_CLASS_PARAMETERS = new Class[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Method[] NO_METHODS = new Method[0];
    private static final Map<MethodDescriptor, Method[]> cache = new ConcurrentReferenceHashMap<MethodDescriptor, Method[]>(256);

    public static void invokeSetter(Object object, String setterName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        MethodUtils.invokeSetter(object, setterName, args);
    }

    public static void invokeSetter(Object object, String setterName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int index = setterName.indexOf(46);
        if (index > 0) {
            String getterName = setterName.substring(0, index);
            Object o = MethodUtils.invokeGetter(object, getterName);
            MethodUtils.invokeSetter(o, setterName.substring(index + 1), args);
        } else {
            if (!setterName.startsWith("set")) {
                setterName = "set" + setterName.substring(0, 1).toUpperCase(Locale.US) + setterName.substring(1);
            }
            MethodUtils.invokeMethod(object, setterName, args);
        }
    }

    public static Object invokeGetter(Object object, String getterName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, getterName);
    }

    public static Object invokeGetter(Object object, String getterName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeGetter(object, getterName, args);
    }

    public static Object invokeGetter(Object object, String getterName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int index = getterName.indexOf(46);
        if (index > 0) {
            String getterName2 = getterName.substring(0, index);
            Object o = MethodUtils.invokeGetter(object, getterName2);
            return MethodUtils.invokeGetter(o, getterName.substring(index + 1), args);
        }
        if (!getterName.startsWith("get") && !getterName.startsWith("is")) {
            getterName = "get" + getterName.substring(0, 1).toUpperCase(Locale.US) + getterName.substring(1);
        }
        return MethodUtils.invokeMethod(object, getterName, args);
    }

    public static Object invokeMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, methodName, EMPTY_OBJECT_ARRAY, EMPTY_CLASS_PARAMETERS);
    }

    public static Object invokeMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeMethod(object, methodName, args);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?>[] paramTypes;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
            paramTypes = EMPTY_CLASS_PARAMETERS;
        } else {
            int len = args.length;
            if (len == 0) {
                paramTypes = EMPTY_CLASS_PARAMETERS;
            } else {
                paramTypes = new Class[len];
                for (int i = 0; i < len; ++i) {
                    if (args[i] == null) continue;
                    paramTypes[i] = args[i].getClass();
                }
            }
        }
        return MethodUtils.invokeMethod(object, methodName, args, paramTypes);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class<?>[] paramTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (paramTypes == null) {
            paramTypes = EMPTY_CLASS_PARAMETERS;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), methodName, args, paramTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return MethodUtils.invokeMethod(object, method, args, paramTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeExactMethod(object, methodName, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?>[] paramTypes;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
            paramTypes = EMPTY_CLASS_PARAMETERS;
        } else {
            int arguments = args.length;
            if (arguments == 0) {
                paramTypes = EMPTY_CLASS_PARAMETERS;
            } else {
                paramTypes = new Class[arguments];
                for (int i = 0; i < arguments; ++i) {
                    if (args[i] == null) continue;
                    paramTypes[i] = args[i].getClass();
                }
            }
        }
        return MethodUtils.invokeExactMethod(object, methodName, args, paramTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class<?>[] paramTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (paramTypes == null) {
            paramTypes = EMPTY_CLASS_PARAMETERS;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), methodName, paramTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactStaticMethod(Class<?> objectClass, String methodName, Object[] args, Class<?>[] paramTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (paramTypes == null) {
            paramTypes = EMPTY_CLASS_PARAMETERS;
        }
        if ((method = MethodUtils.getAccessibleMethod(objectClass, methodName, paramTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + objectClass.getName());
        }
        return method.invoke(null, args);
    }

    public static Object invokeStaticMethod(Class<?> objectClass, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeStaticMethod(objectClass, methodName, EMPTY_OBJECT_ARRAY, EMPTY_CLASS_PARAMETERS);
    }

    public static Object invokeStaticMethod(Class<?> objectClass, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeStaticMethod(objectClass, methodName, args);
    }

    public static Object invokeStaticMethod(Class<?> objectClass, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] paramTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            paramTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeStaticMethod(objectClass, methodName, args, paramTypes);
    }

    public static Object invokeStaticMethod(Class<?> objectClass, String methodName, Object[] args, Class<?>[] paramTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (paramTypes == null) {
            paramTypes = EMPTY_CLASS_PARAMETERS;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(objectClass, methodName, args, paramTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + objectClass.getName());
        }
        return MethodUtils.invokeMethod(null, method, args, paramTypes);
    }

    public static Object invokeExactStaticMethod(Class<?> objectClass, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactStaticMethod(objectClass, methodName, EMPTY_OBJECT_ARRAY, EMPTY_CLASS_PARAMETERS);
    }

    public static Object invokeExactStaticMethod(Class<?> objectClass, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeExactStaticMethod(objectClass, methodName, args);
    }

    public static Object invokeExactStaticMethod(Class<?> objectClass, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args.length;
        Class[] paramTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            paramTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeExactStaticMethod(objectClass, methodName, args, paramTypes);
    }

    private static Object invokeMethod(Object object, Method method, Object[] args, Class<?>[] paramTypes) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?>[] methodsParams = method.getParameterTypes();
        return MethodUtils.invokeMethod(object, method, methodsParams, args, paramTypes);
    }

    private static Object invokeMethod(Object object, Method method, Class<?>[] methodsParams, Object[] args, Class<?>[] paramTypes) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (methodsParams != null && methodsParams.length > 0) {
            Object[] args2 = new Object[methodsParams.length];
            for (int i = 0; i < methodsParams.length; ++i) {
                Class<?> argParamType;
                Class<?> methodParamType;
                args2[i] = args[i];
                if (paramTypes[i] == null || !methodsParams[i].isArray() || (methodParamType = methodsParams[i].getComponentType()).equals(argParamType = paramTypes[i].getComponentType())) continue;
                args2[i] = ReflectionUtils.toComponentTypeArray(args2[i], methodParamType);
            }
            return method.invoke(object, args2);
        }
        return method.invoke(object, args);
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName) {
        return MethodUtils.getAccessibleMethod(clazz, methodName, EMPTY_CLASS_PARAMETERS);
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName, Class<?> paramType) {
        Class[] paramTypes = new Class[]{paramType};
        return MethodUtils.getAccessibleMethod(clazz, methodName, paramTypes);
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        MethodDescriptor md = new MethodDescriptor(clazz, methodName, paramTypes, true);
        Method[] result = cache.get(md);
        if (result == null) {
            try {
                Method method = MethodUtils.getAccessibleMethod(clazz.getMethod(methodName, paramTypes));
                result = new Method[]{method};
            }
            catch (NoSuchMethodException e) {
                result = NO_METHODS;
            }
            cache.put(md, result);
        }
        return result.length > 0 ? result[0] : null;
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        return MethodUtils.getAccessibleMethod(method.getDeclaringClass(), method);
    }

    public static Method getAccessibleMethod(Class<?> clazz, Method method) {
        Class<?>[] paramTypes;
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        if (clazz == null) {
            clazz = method.getDeclaringClass();
        } else if (!method.getDeclaringClass().isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not assignable from " + method.getDeclaringClass().getName());
        }
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String methodName = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, methodName, paramTypes = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(clazz, methodName, paramTypes);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        for (Class<?> parentClazz = clazz.getSuperclass(); parentClazz != null; parentClazz = parentClazz.getSuperclass()) {
            if (!Modifier.isPublic(parentClazz.getModifiers())) continue;
            try {
                return parentClazz.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
                if (!Modifier.isPublic(anInterface.getModifiers())) continue;
                try {
                    method = anInterface.getDeclaredMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method != null) {
                    return method;
                }
                method = MethodUtils.getAccessibleMethodFromInterfaceNest(anInterface, methodName, paramTypes);
                if (method == null) continue;
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class<?> clazz, String methodName, Object[] args, Class<?>[] paramTypes) {
        MethodDescriptor md = new MethodDescriptor(clazz, methodName, paramTypes, false);
        Method[] result = cache.get(md);
        if (result != null) {
            return result.length > 0 ? result[0] : null;
        }
        try {
            Method method = clazz.getMethod(methodName, paramTypes);
            cache.put(md, new Method[]{method});
            return method;
        }
        catch (NoSuchMethodException method) {
            int paramSize = paramTypes.length;
            Method bestMatch = null;
            Method[] methods = clazz.getMethods();
            float bestMatchWeight = Float.MAX_VALUE;
            for (Method method2 : methods) {
                float myWeight;
                if (!method2.getName().equals(methodName) || method2.getParameterCount() != paramSize) continue;
                Class<?>[] methodsParams = method2.getParameterTypes();
                boolean paramMatch = true;
                for (int n = 0; n < methodsParams.length; ++n) {
                    if (args != null) {
                        if (TypeUtils.isAssignableValue(methodsParams[n], args[n])) continue;
                        paramMatch = false;
                        break;
                    }
                    if (TypeUtils.isAssignable(methodsParams[n], paramTypes[n])) continue;
                    paramMatch = false;
                    break;
                }
                if (!paramMatch || !((myWeight = args != null ? ReflectionUtils.getTypeDifferenceWeight(methodsParams, args) : ReflectionUtils.getTypeDifferenceWeight(methodsParams, paramTypes)) < bestMatchWeight)) continue;
                bestMatch = method2;
                bestMatchWeight = myWeight;
            }
            if (bestMatch != null) {
                cache.put(md, new Method[]{bestMatch});
            } else {
                cache.put(md, NO_METHODS);
            }
            return bestMatch;
        }
    }

    public static Method getMatchingAccessibleMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        return MethodUtils.getMatchingAccessibleMethod(clazz, methodName, null, paramTypes);
    }

    public static synchronized int clearCache() {
        int size = cache.size();
        cache.clear();
        return size;
    }

    private static class MethodDescriptor {
        private Class<?> cls;
        private String methodName;
        private Class<?>[] paramTypes;
        private boolean exact;
        private volatile int hashCode;

        private MethodDescriptor(Class<?> cls, String methodName, Class<?>[] paramTypes, boolean exact) {
            if (cls == null) {
                throw new IllegalArgumentException("cls must not be null");
            }
            if (methodName == null) {
                throw new IllegalArgumentException("methodName must not be null");
            }
            this.cls = cls;
            this.methodName = methodName;
            this.paramTypes = paramTypes != null ? paramTypes : EMPTY_CLASS_PARAMETERS;
            this.exact = exact;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            MethodDescriptor md = (MethodDescriptor)obj;
            return this.exact == md.exact && this.methodName.equals(md.methodName) && this.cls.equals(md.cls) && Arrays.equals(this.paramTypes, md.paramTypes);
        }

        public int hashCode() {
            int prime = 31;
            int result = this.hashCode;
            if (result == 0) {
                result = 31 * result + this.cls.hashCode();
                result = 31 * result + this.methodName.hashCode();
                result = 31 * result + Arrays.hashCode(this.paramTypes);
                this.hashCode = result = 31 * result + (this.exact ? 1 : 0);
            }
            return result;
        }
    }
}

