/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.ProcessLogger;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;

public class ProcessRunner {
    private static final Log log = LogFactory.getLog(ProcessRunner.class);
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicBoolean terminated = new AtomicBoolean();
    private final ProcessLogger logger;
    private String workingDir;
    private Process process;

    public ProcessRunner() {
        this(null);
    }

    public ProcessRunner(ProcessLogger logger) {
        this.logger = logger;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public int run(String[] command) throws IOException, InterruptedException {
        return this.run(command, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] command, PrintWriter errOut) throws IOException, InterruptedException {
        if (this.running.get()) {
            throw new IllegalStateException("There is already a running process");
        }
        this.running.set(true);
        this.terminated.set(false);
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            if (this.workingDir != null) {
                builder.directory(new File(this.workingDir));
            }
            this.process = builder.start();
            if (this.logger != null || log.isDebugEnabled()) {
                this.readNormalOutput(this.process);
            }
            if (errOut != null || this.logger != null || log.isDebugEnabled()) {
                this.readErrorOutput(this.process, errOut);
            }
            int n = this.process.waitFor();
            return n;
        }
        finally {
            this.process = null;
            this.running.set(false);
        }
    }

    public void runInBackground(String[] command) {
        new Thread(() -> {
            try {
                this.run(command);
            }
            catch (Exception e) {
                String message = "Error running process in background";
                if (this.logger != null) {
                    this.logger.error(message, e);
                }
                log.error(message, e);
            }
        }).start();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public boolean isTerminated() {
        return this.terminated.get();
    }

    public void terminate() {
        if (this.isRunning() && this.process != null) {
            this.terminated.set(true);
            this.process.destroy();
        }
    }

    private void readNormalOutput(Process process) {
        try (InputStream is = process.getInputStream();){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (this.logger != null) {
                    this.logger.info(line);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readErrorOutput(Process process, PrintWriter errOut) {
        try (InputStream is = process.getErrorStream();){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (errOut != null) {
                    errOut.println(line);
                }
                if (this.logger != null) {
                    this.logger.warn(line);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

