/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.security.AccessControlException;

public class SystemUtils {
    private static final Log log = LogFactory.getLog(SystemUtils.class);
    private static final String JAVA_IO_TMPDIR_PROPERTY = "java.io.tmpdir";

    public static String getProperty(String name) {
        try {
            return System.getProperty(name);
        }
        catch (AccessControlException ex) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Caught AccessControlException when accessing system property [%s]; its value will be returned [null]. Reason: %s", name, ex.getMessage()));
            }
            return null;
        }
    }

    public static String getProperty(String name, String defVal) {
        String val = SystemUtils.getProperty(name);
        return val != null ? val : defVal;
    }

    public static String getJavaIoTmpDir() {
        return SystemUtils.getProperty(JAVA_IO_TMPDIR_PROPERTY);
    }
}

