/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.thread;

import com.aspectran.core.util.thread.Scheduler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorScheduler
implements Scheduler {
    private final String name;
    private final boolean daemon;
    private final ClassLoader classloader;
    private final ThreadGroup threadGroup;
    private volatile ScheduledThreadPoolExecutor executor;

    public ScheduledExecutorScheduler() {
        this(null, false);
    }

    public ScheduledExecutorScheduler(String name, boolean daemon) {
        this(name, daemon, null);
    }

    public ScheduledExecutorScheduler(String name, boolean daemon, ClassLoader classLoader) {
        this(name, daemon, classLoader, null);
    }

    public ScheduledExecutorScheduler(String name, boolean daemon, ClassLoader classLoader, ThreadGroup threadGroup) {
        this.name = name == null ? "scheduler-" + this.hashCode() : name;
        this.daemon = daemon;
        this.classloader = classLoader;
        this.threadGroup = threadGroup;
    }

    @Override
    public Scheduler.Task schedule(Runnable task, long delay, TimeUnit unit) {
        ScheduledThreadPoolExecutor executor = this.executor;
        if (executor == null) {
            return () -> false;
        }
        ScheduledFuture<?> result = executor.schedule(task, delay, unit);
        return new ScheduledFutureTask(result);
    }

    @Override
    public synchronized void start() {
        if (this.executor != null) {
            throw new IllegalStateException("Scheduler " + this.name + " is already running");
        }
        this.executor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = new Thread(this.threadGroup, r, this.name);
            thread.setDaemon(this.daemon);
            if (this.classloader != null) {
                thread.setContextClassLoader(this.classloader);
            }
            return thread;
        });
        this.executor.setRemoveOnCancelPolicy(true);
    }

    @Override
    public synchronized void stop() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    @Override
    public boolean isRunning() {
        return this.executor != null;
    }

    private static class ScheduledFutureTask
    implements Scheduler.Task {
        private final ScheduledFuture<?> scheduledFuture;

        ScheduledFutureTask(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public boolean cancel() {
            return this.scheduledFuture.cancel(false);
        }
    }
}

