/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process;

import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.Objects;

public class ContentList
extends ArrayList<ActionList>
implements Replicable<ContentList> {
    private static final long serialVersionUID = 2567969961069441527L;
    private final boolean explicit;
    private String name;

    public ContentList(boolean explicit) {
        super(3);
        this.explicit = explicit;
    }

    protected ContentList(ContentList contentList) {
        super(contentList);
        this.explicit = contentList.isExplicit();
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActionList getActionList(String name) {
        for (ActionList actionList : this) {
            if (!Objects.equals(name, actionList.getName())) continue;
            return actionList;
        }
        return null;
    }

    public void addActionList(ActionList actionList) {
        if (actionList != null) {
            this.add(actionList);
        }
    }

    @Override
    public ContentList replicate() {
        ContentList contentList = new ContentList(this);
        contentList.setName(this.name);
        return contentList;
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("name", this.name);
        tsb.append("contents", this);
        return tsb.toString();
    }

    public static ContentList newInstance(String name) {
        ContentList contentList = new ContentList(true);
        contentList.setName(name);
        return contentList;
    }
}

