/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.request;

import com.aspectran.core.util.FilenameUtils;
import com.aspectran.core.util.ToStringBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileParameter {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final File file;
    private boolean refused;
    private File savedFile;

    protected FileParameter() {
        this.file = null;
    }

    public FileParameter(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.file != null ? this.file.getName() : null;
    }

    public long getFileSize() {
        return this.file != null ? this.file.length() : -1L;
    }

    public String getContentType() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file == null) {
            throw new IOException("No file specified for this file parameter " + this);
        }
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        InputStream input = this.getInputStream();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            int len;
            while ((len = input.read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
        }
        finally {
            try {
                output.close();
            }
            catch (IOException iOException) {}
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return output.toByteArray();
    }

    public boolean isRefused() {
        return this.refused;
    }

    public void setRefused(boolean refused) {
        this.refused = refused;
    }

    public File saveAs(File destFile) throws IOException {
        return this.saveAs(destFile, false);
    }

    public File saveAs(File destFile, boolean overwrite) throws IOException {
        if (destFile == null) {
            throw new IllegalArgumentException("destFile can not be null");
        }
        try {
            destFile = this.determineDestinationFile(destFile, overwrite);
            byte[] buffer = new byte[4096];
            try (InputStream input = this.getInputStream();
                 FileOutputStream output = new FileOutputStream(destFile);){
                int len;
                while ((len = input.read(buffer)) != -1) {
                    ((OutputStream)output).write(buffer, 0, len);
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Could not save as file " + destFile, e);
        }
        this.setSavedFile(destFile);
        return destFile;
    }

    public File renameTo(File destFile) throws IOException {
        return this.renameTo(destFile, false);
    }

    public File renameTo(File destFile, boolean overwrite) throws IOException {
        File srcFile = this.getFile();
        if (srcFile == null) {
            throw new IllegalStateException("The specified file does not exist");
        }
        if (destFile == null) {
            throw new IllegalArgumentException("destFile can not be null");
        }
        try {
            destFile = this.determineDestinationFile(destFile, overwrite);
            if (!srcFile.renameTo(destFile)) {
                throw new IOException("Could not rename file " + srcFile + " to " + destFile);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Could not rename file", e);
        }
        this.setSavedFile(destFile);
        return destFile;
    }

    protected File determineDestinationFile(File destFile, boolean overwrite) throws IOException {
        if (overwrite) {
            if (destFile.exists() && !destFile.delete()) {
                throw new IOException("Destination file [" + destFile.getAbsolutePath() + "] already exists and could not be deleted");
            }
            return destFile;
        }
        return FilenameUtils.generateUniqueFile(destFile);
    }

    public File getSavedFile() {
        return this.savedFile;
    }

    protected void setSavedFile(File savedFile) {
        this.savedFile = savedFile;
    }

    protected void releaseSavedFile() {
        if (this.savedFile != null) {
            this.savedFile.setWritable(true);
            this.savedFile = null;
        }
    }

    public void delete() {
        if (this.file != null) {
            this.file.delete();
        }
    }

    public void rollback() {
        if (this.savedFile != null) {
            this.savedFile.delete();
        }
    }

    public void release() {
        if (this.file != null) {
            this.file.setWritable(true);
        }
        if (this.savedFile != null) {
            this.savedFile.setWritable(true);
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("file", this.file);
        tsb.append("savedFile", this.savedFile);
        tsb.append("refused", this.refused);
        return tsb.toString();
    }
}

