/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseException;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;

public class RedirectResponse
implements Response {
    private static final Log log = LogFactory.getLog(RedirectResponse.class);
    private final RedirectRule redirectRule;

    public RedirectResponse(RedirectRule redirectRule) {
        this.redirectRule = redirectRule;
    }

    @Override
    public void commit(Activity activity) throws ResponseException {
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        if (responseAdapter == null) {
            return;
        }
        RedirectRule newRedirectRule = this.redirectRule.replicate();
        if (log.isDebugEnabled()) {
            log.debug("Response " + newRedirectRule);
        }
        try {
            if (newRedirectRule.getEncoding() != null) {
                responseAdapter.setEncoding(newRedirectRule.getEncoding());
            } else {
                String encoding = activity.getTranslet().getIntendedResponseEncoding();
                if (encoding != null) {
                    responseAdapter.setEncoding(encoding);
                    newRedirectRule.setEncoding(encoding);
                } else {
                    newRedirectRule.setEncoding(responseAdapter.getEncoding());
                }
            }
            responseAdapter.redirect(newRedirectRule);
        }
        catch (Exception e) {
            throw new ResponseException("Failed to respond with redirect rule " + newRedirectRule, e);
        }
    }

    @Override
    public ResponseType getResponseType() {
        return RedirectRule.RESPONSE_TYPE;
    }

    @Override
    public String getContentType() {
        if (this.redirectRule != null) {
            return this.redirectRule.getContentType();
        }
        return null;
    }

    @Override
    public Response replicate() {
        return new RedirectResponse(this.redirectRule.replicate());
    }

    public RedirectRule getRedirectRule() {
        return this.redirectRule;
    }

    public String toString() {
        return this.redirectRule.toString();
    }
}

