/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.FormattingContext;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseException;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.TransformResponseException;
import com.aspectran.core.activity.response.transform.xml.ContentsInputSource;
import com.aspectran.core.activity.response.transform.xml.ContentsXMLReader;
import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.type.ContentType;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XslTransformResponse
extends TransformResponse {
    private static final String OUTPUT_METHOD_XML = "xml";
    private static final String OUTPUT_METHOD_HTML = "html";
    private static final String OUTPUT_METHOD_TEXT = "text";
    private static final Log log = LogFactory.getLog(XslTransformResponse.class);
    private final TemplateRule templateRule;
    private Templates templates;
    private String contentType;
    private String outputEncoding;
    private volatile long templateLastModifiedTime;
    private volatile boolean templateLoaded;

    public XslTransformResponse(TransformRule transformRule) {
        super(transformRule);
        this.templateRule = transformRule.getTemplateRule();
    }

    @Override
    public void commit(Activity activity) throws ResponseException {
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        if (responseAdapter == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Response " + this.getTransformRule());
        }
        try {
            this.loadTemplate(activity.getActivityContext().getApplicationAdapter());
            if (this.outputEncoding != null) {
                responseAdapter.setEncoding(this.outputEncoding);
            }
            if (this.contentType != null) {
                responseAdapter.setContentType(this.contentType);
            }
            Writer writer = responseAdapter.getWriter();
            ProcessResult processResult = activity.getProcessResult();
            ContentsXMLReader xmlReader = new ContentsXMLReader();
            FormattingContext formattingContext = FormattingContext.parse(activity);
            if (formattingContext.getDateFormat() != null) {
                xmlReader.setDateFormat(formattingContext.getDateFormat());
            }
            if (formattingContext.getDateTimeFormat() != null) {
                xmlReader.setDateTimeFormat(formattingContext.getDateTimeFormat());
            }
            ContentsInputSource inputSource = new ContentsInputSource(processResult);
            SAXSource source = new SAXSource(xmlReader, inputSource);
            Transformer transformer = this.templates.newTransformer();
            transformer.transform(source, new StreamResult(writer));
        }
        catch (Exception e) {
            throw new TransformResponseException(this.getTransformRule(), (Throwable)e);
        }
    }

    @Override
    public Response replicate() {
        return new XslTransformResponse(this.getTransformRule().replicate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTemplate(ApplicationAdapter applicationAdapter) throws TransformerConfigurationException, IOException {
        String templateFile = this.templateRule.getFile();
        String templateResource = this.templateRule.getResource();
        String templateUrl = this.templateRule.getUrl();
        boolean noCache = this.templateRule.isNoCache();
        if (templateFile != null) {
            if (noCache) {
                File file = applicationAdapter.toRealPathAsFile(templateFile);
                this.templates = this.createTemplates(file);
                this.determineOutputStyle();
            } else {
                File file = applicationAdapter.toRealPathAsFile(templateFile);
                long lastModifiedTime = file.lastModified();
                if (lastModifiedTime > this.templateLastModifiedTime) {
                    XslTransformResponse xslTransformResponse = this;
                    synchronized (xslTransformResponse) {
                        lastModifiedTime = file.lastModified();
                        if (lastModifiedTime > this.templateLastModifiedTime) {
                            this.templates = this.createTemplates(file);
                            this.determineOutputStyle();
                            this.templateLastModifiedTime = lastModifiedTime;
                        }
                    }
                }
            }
        } else if (templateResource != null) {
            if (noCache) {
                ClassLoader classLoader = applicationAdapter.getClassLoader();
                this.templates = this.createTemplates(Objects.requireNonNull(classLoader.getResource(templateResource)));
                this.determineOutputStyle();
            } else if (!this.templateLoaded) {
                XslTransformResponse xslTransformResponse = this;
                synchronized (xslTransformResponse) {
                    if (!this.templateLoaded) {
                        ClassLoader classLoader = applicationAdapter.getClassLoader();
                        this.templates = this.createTemplates(Objects.requireNonNull(classLoader.getResource(templateResource)));
                        this.determineOutputStyle();
                        this.templateLoaded = true;
                    }
                }
            }
        } else if (templateUrl != null) {
            if (noCache) {
                this.templates = this.createTemplates(new URL(templateUrl));
                this.determineOutputStyle();
            } else if (!this.templateLoaded) {
                XslTransformResponse xslTransformResponse = this;
                synchronized (xslTransformResponse) {
                    if (!this.templateLoaded) {
                        this.templates = this.createTemplates(new URL(templateUrl));
                        this.determineOutputStyle();
                        this.templateLoaded = true;
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("No specified template " + this.templateRule);
        }
    }

    private void determineOutputStyle() {
        this.contentType = this.getTransformRule().getContentType();
        if (this.contentType == null) {
            this.contentType = this.getContentType(this.templates);
        }
        this.outputEncoding = this.getOutputEncoding(this.templates);
        if (this.outputEncoding == null) {
            this.outputEncoding = this.getTransformRule().getEncoding();
        }
    }

    private Templates createTemplates(File templateFile) throws TransformerConfigurationException {
        StreamSource source = new StreamSource(templateFile);
        return this.createTemplates(source);
    }

    private Templates createTemplates(URL url) throws TransformerConfigurationException, IOException {
        URLConnection conn = url.openConnection();
        StreamSource source = new StreamSource(conn.getInputStream());
        return this.createTemplates(source);
    }

    private Templates createTemplates(Source source) throws TransformerConfigurationException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        transFactory.setAttribute("generate-translet", Boolean.TRUE);
        return transFactory.newTemplates(source);
    }

    private String getContentType(Templates templates) {
        Properties outputProperties = templates.getOutputProperties();
        String outputMethod = outputProperties.getProperty("method");
        String contentType = null;
        if (outputMethod != null) {
            if (outputMethod.equalsIgnoreCase(OUTPUT_METHOD_XML)) {
                contentType = ContentType.APPLICATION_XML.toString();
            } else if (outputMethod.equalsIgnoreCase(OUTPUT_METHOD_HTML)) {
                contentType = ContentType.TEXT_HTML.toString();
            } else if (outputMethod.equalsIgnoreCase(OUTPUT_METHOD_TEXT)) {
                contentType = ContentType.TEXT_PLAIN.toString();
            }
        }
        return contentType;
    }

    private String getOutputEncoding(Templates templates) {
        Properties outputProperties = templates.getOutputProperties();
        return outputProperties.getProperty("encoding");
    }
}

