/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class AspectRuleRegistry
extends AbstractComponent {
    private static final Log log = LogFactory.getLog(AspectRuleRegistry.class);
    private final Map<String, AspectRule> aspectRuleMap = new LinkedHashMap<String, AspectRule>();

    public Collection<AspectRule> getAspectRules() {
        return this.aspectRuleMap.values();
    }

    public AspectRule getAspectRule(String aspectId) {
        return this.aspectRuleMap.get(aspectId);
    }

    public boolean contains(String aspectId) {
        return this.aspectRuleMap.containsKey(aspectId);
    }

    public void addAspectRule(AspectRule aspectRule) throws IllegalRuleException {
        if (aspectRule == null) {
            throw new IllegalArgumentException("aspectRule must not be null");
        }
        AspectRule old = this.aspectRuleMap.put(aspectRule.getId(), aspectRule);
        if (old != null) {
            throw new IllegalRuleException("Cannot add an Aspect Rule because of Duplicate Aspect ID: " + aspectRule.getId());
        }
        if (log.isTraceEnabled()) {
            log.trace("add AspectRule " + aspectRule);
        }
    }

    @Override
    protected void doInitialize() {
    }

    @Override
    protected void doDestroy() {
        this.aspectRuleMap.clear();
    }
}

