/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect.pointcut;

import com.aspectran.core.component.aspect.pointcut.AbstractPointcut;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.core.util.ConcurrentReferenceHashMap;
import com.aspectran.core.util.wildcard.WildcardPattern;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class WildcardPointcut
extends AbstractPointcut {
    private static final String OR_MATCH_DELIMITER = "|";
    private final Map<String, WildcardPattern> cache = new ConcurrentReferenceHashMap<String, WildcardPattern>();

    public WildcardPointcut(List<PointcutPatternRule> pointcutPatternRuleList) {
        super(pointcutPatternRuleList);
    }

    @Override
    public boolean patternMatches(String pattern, String compareString) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern must not be null");
        }
        if (pattern.contains(OR_MATCH_DELIMITER)) {
            StringTokenizer parser = new StringTokenizer(pattern, OR_MATCH_DELIMITER);
            while (parser.hasMoreTokens()) {
                if (!this.wildcardPatternMatches(parser.nextToken(), compareString)) continue;
                return true;
            }
            return false;
        }
        return this.wildcardPatternMatches(pattern, compareString);
    }

    @Override
    public boolean patternMatches(String pattern, String compareString, char separator) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern must not be null");
        }
        if (pattern.contains(OR_MATCH_DELIMITER)) {
            StringTokenizer parser = new StringTokenizer(pattern, OR_MATCH_DELIMITER);
            while (parser.hasMoreTokens()) {
                if (!this.wildcardPatternMatches(parser.nextToken(), compareString, separator)) continue;
                return true;
            }
            return false;
        }
        return this.wildcardPatternMatches(pattern, compareString, separator);
    }

    private boolean wildcardPatternMatches(String pattern, String compareString) {
        WildcardPattern existing;
        if (!WildcardPattern.hasWildcards(pattern)) {
            return pattern.equals(compareString);
        }
        WildcardPattern wildcardPattern = this.cache.get(pattern);
        if (wildcardPattern == null && (existing = this.cache.putIfAbsent(pattern, wildcardPattern = new WildcardPattern(pattern))) != null) {
            wildcardPattern = existing;
        }
        return wildcardPattern.matches(compareString);
    }

    private boolean wildcardPatternMatches(String pattern, String compareString, char separator) {
        WildcardPattern existing;
        if (pattern.indexOf(separator) == -1 && !WildcardPattern.hasWildcards(pattern)) {
            return pattern.equals(compareString);
        }
        String patternKey = pattern + separator;
        WildcardPattern wildcardPattern = this.cache.get(patternKey);
        if (wildcardPattern == null && (existing = this.cache.putIfAbsent(patternKey, wildcardPattern = new WildcardPattern(pattern, separator))) != null) {
            wildcardPattern = existing;
        }
        return wildcardPattern.matches(compareString);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

