/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.action.AnnotatedAction;
import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.bean.BeanCreationException;
import com.aspectran.core.component.bean.BeanInstance;
import com.aspectran.core.component.bean.BeanInstantiationException;
import com.aspectran.core.component.bean.FactoryBeanNotInitializedException;
import com.aspectran.core.component.bean.NoSuchBeanException;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.component.bean.ablility.FactoryBean;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.core.component.bean.ablility.InitializableTransletBean;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.core.component.bean.aware.Aware;
import com.aspectran.core.component.bean.aware.ClassLoaderAware;
import com.aspectran.core.component.bean.aware.CurrentActivityAware;
import com.aspectran.core.component.bean.aware.EnvironmentAware;
import com.aspectran.core.component.bean.proxy.CglibDynamicProxyBean;
import com.aspectran.core.component.bean.proxy.JavassistDynamicProxyBean;
import com.aspectran.core.component.bean.proxy.JdkDynamicProxyBean;
import com.aspectran.core.component.bean.scope.Scope;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.expr.ItemExpression;
import com.aspectran.core.context.expr.TokenExpression;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.rule.AutowireRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.ItemRuleUtils;
import com.aspectran.core.context.rule.ParameterBindingRule;
import com.aspectran.core.context.rule.type.AutowireTargetType;
import com.aspectran.core.context.rule.type.BeanProxifierType;
import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.MethodUtils;
import com.aspectran.core.util.ReflectionUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;

abstract class AbstractBeanFactory
extends AbstractComponent {
    private static final Log log = LogFactory.getLog(AbstractBeanFactory.class);
    private final ActivityContext context;
    private final BeanProxifierType beanProxifierType;

    AbstractBeanFactory(ActivityContext context, BeanProxifierType beanProxifierType) {
        this.context = context;
        this.beanProxifierType = beanProxifierType != null ? beanProxifierType : BeanProxifierType.JAVASSIST;
    }

    protected ActivityContext getActivityContext() {
        return this.context;
    }

    protected Object createBean(BeanRule beanRule) {
        Activity activity = this.context.getCurrentActivity();
        return this.createBean(beanRule, null, activity);
    }

    protected Object createBean(BeanRule beanRule, Scope scope) {
        Activity activity = this.context.getCurrentActivity();
        return this.createBean(beanRule, scope, activity);
    }

    protected Object getFactoryProducedObject(BeanRule beanRule, Object bean) {
        if (beanRule.isFactoryBean()) {
            return this.invokeMethodOfFactoryBean(beanRule, bean);
        }
        if (beanRule.getFactoryMethodName() != null) {
            Activity activity = this.context.getCurrentActivity();
            return this.invokeFactoryMethod(beanRule, bean, activity);
        }
        return null;
    }

    protected Object createBean(BeanRule beanRule, Scope scope, Activity activity) {
        Object bean = beanRule.isFactoryOffered() ? this.createOfferedFactoryBean(beanRule, scope, activity) : this.createNormalBean(beanRule, scope, activity);
        return bean;
    }

    private Object createNormalBean(BeanRule beanRule, Scope scope, Activity activity) {
        try {
            Object value;
            Class<?>[] argTypes;
            Object[] args;
            ItemExpression evaluator = null;
            ItemRuleMap constructorArgumentItemRuleMap = beanRule.getConstructorArgumentItemRuleMap();
            if (constructorArgumentItemRuleMap != null && !constructorArgumentItemRuleMap.isEmpty()) {
                evaluator = new ItemExpression(activity);
                Map<String, Object> valueMap = evaluator.evaluate(constructorArgumentItemRuleMap);
                args = new Object[constructorArgumentItemRuleMap.size()];
                argTypes = new Class[constructorArgumentItemRuleMap.size()];
                int i = 0;
                for (Map.Entry entry : constructorArgumentItemRuleMap.entrySet()) {
                    args[i] = value = valueMap.get(entry.getKey());
                    argTypes[i] = ItemRuleUtils.getPrototypeClass((ItemRule)entry.getValue(), value);
                    ++i;
                }
            } else {
                AutowireRule ctorAutowireRule = beanRule.getConstructorAutowireRule();
                if (ctorAutowireRule != null) {
                    Class<?>[] types = ctorAutowireRule.getTypes();
                    String[] qualifiers = ctorAutowireRule.getQualifiers();
                    args = new Object[types.length];
                    argTypes = new Class[types.length];
                    for (int i = 0; i < types.length; ++i) {
                        if (ctorAutowireRule.isRequired()) {
                            try {
                                args[i] = activity.getBean(types[i], qualifiers[i]);
                            }
                            catch (NoSuchBeanException | NoUniqueBeanException e) {
                                throw new BeanCreationException("Could not autowire constructor: " + ctorAutowireRule, beanRule);
                            }
                        }
                        try {
                            args[i] = activity.getBean(types[i], qualifiers[i]);
                        }
                        catch (NoSuchBeanException | NoUniqueBeanException e) {
                            args[i] = null;
                            log.warn(e.getMessage());
                        }
                        argTypes[i] = types[i];
                    }
                } else {
                    args = MethodUtils.EMPTY_OBJECT_ARRAY;
                    argTypes = MethodUtils.EMPTY_CLASS_PARAMETERS;
                }
            }
            Object bean = this.instantiateBean(beanRule, args, argTypes);
            if (scope != null) {
                scope.putBeanInstance(activity, beanRule, new BeanInstance(bean));
            }
            this.invokeAwareMethods(bean);
            this.autowiring(beanRule, bean, activity);
            ItemRuleMap propertyItemRuleMap = beanRule.getPropertyItemRuleMap();
            if (propertyItemRuleMap != null && !propertyItemRuleMap.isEmpty()) {
                if (evaluator == null) {
                    evaluator = new ItemExpression(activity);
                }
                for (Map.Entry entry : propertyItemRuleMap.entrySet()) {
                    value = evaluator.evaluate((ItemRule)entry.getValue());
                    MethodUtils.invokeSetter(bean, (String)entry.getKey(), value);
                }
            }
            if (beanRule.isInitializableBean() || beanRule.isInitializableTransletBean()) {
                this.initializeBean(beanRule, bean, activity);
            } else if (beanRule.getInitMethod() != null) {
                this.invokeInitMethod(beanRule, bean, activity);
            }
            return bean;
        }
        catch (BeanCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanCreationException(beanRule, (Throwable)e);
        }
    }

    private Object createOfferedFactoryBean(BeanRule beanRule, Scope scope, Activity activity) {
        Object bean;
        String factoryBeanId = beanRule.getFactoryBeanId();
        Class<?> factoryBeanClass = beanRule.getFactoryBeanClass();
        try {
            bean = factoryBeanClass != null ? (Modifier.isInterface(factoryBeanClass.getModifiers()) ? null : activity.getBean(factoryBeanClass)) : activity.getBean(factoryBeanId);
            bean = this.invokeFactoryMethod(beanRule, bean, activity);
            if (bean == null) {
                throw new NullPointerException("Factory Method [" + beanRule.getFactoryMethod() + "] has returned null");
            }
        }
        catch (BeanCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanCreationException("An exception occurred while invoking a factory method from the offered factory bean", beanRule, e);
        }
        if (scope != null) {
            scope.putBeanInstance(activity, beanRule, new BeanInstance(bean));
        }
        try {
            ItemRuleMap propertyItemRuleMap = beanRule.getPropertyItemRuleMap();
            if (propertyItemRuleMap != null && !propertyItemRuleMap.isEmpty()) {
                ItemExpression evaluator = new ItemExpression(activity);
                for (Map.Entry entry : propertyItemRuleMap.entrySet()) {
                    Object value = evaluator.evaluate((ItemRule)entry.getValue());
                    MethodUtils.invokeSetter(bean, (String)entry.getKey(), value);
                }
            }
            if (beanRule.getInitMethod() != null) {
                this.invokeInitMethod(beanRule, bean, activity);
            }
            return bean;
        }
        catch (BeanCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanCreationException(beanRule, (Throwable)e);
        }
    }

    private Object instantiateBean(BeanRule beanRule, Object[] args, Class<?>[] argTypes) {
        Object bean = beanRule.isProxied() ? this.instantiateDynamicBeanProxy(beanRule, args, argTypes) : (args != null ? AbstractBeanFactory.newInstance(beanRule.getBeanClass(), args, argTypes) : AbstractBeanFactory.newInstance(beanRule.getBeanClass()));
        return bean;
    }

    private Object instantiateDynamicBeanProxy(BeanRule beanRule, Object[] args, Class<?>[] argTypes) {
        Object bean;
        if (this.beanProxifierType == BeanProxifierType.JAVASSIST) {
            if (log.isTraceEnabled()) {
                log.trace("Create a dynamic proxy bean " + beanRule + " using Javassist");
            }
            bean = JavassistDynamicProxyBean.newInstance(this.context, beanRule, args, argTypes);
        } else if (this.beanProxifierType == BeanProxifierType.CGLIB) {
            if (log.isTraceEnabled()) {
                log.trace("Create a dynamic proxy bean " + beanRule + " using CGLIB");
            }
            bean = CglibDynamicProxyBean.newInstance(this.context, beanRule, args, argTypes);
        } else {
            bean = argTypes != null && args != null ? AbstractBeanFactory.newInstance(beanRule.getBeanClass(), args, argTypes) : AbstractBeanFactory.newInstance(beanRule.getBeanClass());
            if (log.isTraceEnabled()) {
                log.trace("Create a dynamic proxy bean " + beanRule + " using JDK");
            }
            bean = JdkDynamicProxyBean.newInstance(this.context, beanRule, bean);
        }
        return bean;
    }

    private void autowiring(BeanRule beanRule, Object bean, Activity activity) {
        if (beanRule.getAutowireRuleList() != null) {
            for (AutowireRule autowireRule : beanRule.getAutowireRuleList()) {
                Object value;
                String[] qualifiers;
                Class<?>[] types;
                Field field;
                if (autowireRule.getTargetType() == AutowireTargetType.FIELD) {
                    field = (Field)autowireRule.getTarget();
                    types = autowireRule.getTypes();
                    qualifiers = autowireRule.getQualifiers();
                    if (autowireRule.isRequired()) {
                        try {
                            value = activity.getBean(types[0], qualifiers[0]);
                        }
                        catch (NoSuchBeanException | NoUniqueBeanException e) {
                            throw new BeanCreationException("Could not autowire field: " + autowireRule, beanRule);
                        }
                    }
                    try {
                        value = activity.getBean(types[0], qualifiers[0]);
                    }
                    catch (NoSuchBeanException | NoUniqueBeanException e) {
                        value = null;
                        log.warn(e.getMessage());
                    }
                    ReflectionUtils.setField(field, bean, value);
                    continue;
                }
                if (autowireRule.getTargetType() == AutowireTargetType.FIELD_VALUE) {
                    field = (Field)autowireRule.getTarget();
                    Token token = autowireRule.getToken();
                    TokenExpression evaluator = new TokenExpression(activity);
                    value = evaluator.evaluate(token);
                    ReflectionUtils.setField(field, bean, value);
                    continue;
                }
                if (autowireRule.getTargetType() != AutowireTargetType.METHOD) continue;
                Method method = (Method)autowireRule.getTarget();
                types = autowireRule.getTypes();
                qualifiers = autowireRule.getQualifiers();
                Object[] args = new Object[types.length];
                for (int i = 0; i < types.length; ++i) {
                    if (autowireRule.isRequired()) {
                        try {
                            args[i] = activity.getBean(types[i], qualifiers[i]);
                            continue;
                        }
                        catch (NoSuchBeanException | NoUniqueBeanException e) {
                            throw new BeanCreationException("Could not autowire method: " + autowireRule, beanRule);
                        }
                    }
                    try {
                        args[i] = activity.getBean(types[i], qualifiers[i]);
                        continue;
                    }
                    catch (NoSuchBeanException | NoUniqueBeanException e) {
                        args[i] = null;
                        log.warn(e.getMessage());
                    }
                }
                ReflectionUtils.invokeMethod(method, bean, args);
            }
        }
    }

    private void invokeAwareMethods(Object bean) {
        if (bean instanceof Aware) {
            if (bean instanceof CurrentActivityAware) {
                ((CurrentActivityAware)bean).setCurrentActivity(this.context.getCurrentActivity());
            }
            if (bean instanceof ActivityContextAware) {
                ((ActivityContextAware)bean).setActivityContext(this.context);
            }
            if (bean instanceof ApplicationAdapterAware) {
                ((ApplicationAdapterAware)bean).setApplicationAdapter(this.context.getApplicationAdapter());
            }
            if (bean instanceof ClassLoaderAware) {
                ((ClassLoaderAware)bean).setClassLoader(this.context.getApplicationAdapter().getClassLoader());
            }
            if (bean instanceof EnvironmentAware) {
                ((EnvironmentAware)bean).setEnvironment(this.context.getEnvironment());
            }
        }
    }

    private void initializeBean(BeanRule beanRule, Object bean, Activity activity) {
        try {
            if (beanRule.isInitializableBean()) {
                ((InitializableBean)bean).initialize();
            } else if (beanRule.isInitializableTransletBean()) {
                ((InitializableTransletBean)bean).initialize(activity.getTranslet());
            }
        }
        catch (Exception e) {
            throw new BeanCreationException("An exception occurred while initialization of bean", beanRule, e);
        }
    }

    private void invokeInitMethod(BeanRule beanRule, Object bean, Activity activity) {
        try {
            Method initMethod = beanRule.getInitMethod();
            ParameterBindingRule[] parameterBindingRules = beanRule.getInitMethodParameterBindingRules();
            AnnotatedAction.invokeMethod(activity, bean, initMethod, parameterBindingRules);
        }
        catch (Exception e) {
            throw new BeanCreationException("An exception occurred while executing an initialization method of bean", beanRule, e);
        }
    }

    private Object invokeFactoryMethod(BeanRule beanRule, Object bean, Activity activity) {
        try {
            Method factoryMethod = beanRule.getFactoryMethod();
            ParameterBindingRule[] parameterBindingRules = beanRule.getFactoryMethodParameterBindingRules();
            return AnnotatedAction.invokeMethod(activity, bean, factoryMethod, parameterBindingRules);
        }
        catch (Exception e) {
            throw new BeanCreationException("An exception occurred while executing a factory method of bean", beanRule, e);
        }
    }

    private Object invokeMethodOfFactoryBean(BeanRule beanRule, Object bean) {
        Object resultBean;
        try {
            resultBean = ((FactoryBean)bean).getObject();
        }
        catch (Exception e) {
            throw new BeanCreationException("FactoryBean threw exception on object creation", beanRule, e);
        }
        if (resultBean == null) {
            throw new FactoryBeanNotInitializedException("FactoryBean returned null object: probably not fully initialized (maybe due to circular bean reference)", beanRule);
        }
        return resultBean;
    }

    private static Object newInstance(Class<?> beanClass, Object[] args, Class<?>[] argTypes) {
        Constructor<?> constructorToUse;
        if (beanClass.isInterface()) {
            throw new BeanInstantiationException(beanClass, "Specified class is an interface");
        }
        try {
            constructorToUse = AbstractBeanFactory.getMatchConstructor(beanClass, args);
            if (constructorToUse == null) {
                constructorToUse = ClassUtils.findConstructor(beanClass, argTypes);
            }
        }
        catch (NoSuchMethodException e) {
            throw new BeanInstantiationException(beanClass, "No default constructor found", e);
        }
        return AbstractBeanFactory.newInstance(constructorToUse, args);
    }

    private static Object newInstance(Class<?> beanClass) {
        return AbstractBeanFactory.newInstance(beanClass, MethodUtils.EMPTY_OBJECT_ARRAY, MethodUtils.EMPTY_CLASS_PARAMETERS);
    }

    private static Object newInstance(Constructor<?> ctor, Object[] args) {
        try {
            return ctor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Is it an abstract class?", e);
        }
        catch (IllegalAccessException e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Has the class definition changed? Is the constructor accessible?", e);
        }
        catch (IllegalArgumentException e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Illegal arguments for constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Constructor threw exception", e.getTargetException());
        }
    }

    private static Constructor<?> getMatchConstructor(Class<?> beanClass, Object[] args) {
        Constructor<?>[] candidates = beanClass.getDeclaredConstructors();
        Constructor<?> constructorToUse = null;
        float bestMatchWeight = Float.MAX_VALUE;
        for (Constructor<?> candidate : candidates) {
            float matchWeight = ReflectionUtils.getTypeDifferenceWeight(candidate.getParameterTypes(), args);
            if (!(matchWeight < bestMatchWeight)) continue;
            constructorToUse = candidate;
            bestMatchWeight = matchWeight;
        }
        return constructorToUse;
    }
}

