/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionBindingListener;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.thread.Locker;
import com.aspectran.core.util.timer.CyclicTimeout;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DefaultSession
implements Session {
    private static final Log log = LogFactory.getLog(DefaultSession.class);
    private final Locker locker = new Locker();
    private final SessionData sessionData;
    private final SessionHandler sessionHandler;
    private final SessionInactivityTimer sessionInactivityTimer;
    private boolean newSession;
    private boolean resident;
    private int requests;
    private State state = State.VALID;
    private Session.DestroyedReason destroyedReason;

    protected DefaultSession(SessionData sessionData, SessionHandler sessionHandler, boolean newSession) {
        this.sessionData = sessionData;
        this.sessionHandler = sessionHandler;
        this.newSession = newSession;
        if (newSession) {
            this.sessionData.setDirty(true);
            this.requests = 1;
        }
        this.sessionInactivityTimer = new SessionInactivityTimer();
    }

    public SessionData getSessionData() {
        return this.sessionData;
    }

    public SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    @Override
    public String getId() {
        try (Locker.Lock ignored = this.locker.lock();){
            String string = this.sessionData.getId();
            return string;
        }
    }

    @Override
    public <T> T getAttribute(String name) {
        try (Locker.Lock ignored = this.locker.lock();){
            this.checkValidForRead();
            Object t = this.sessionData.getAttribute(name);
            return t;
        }
    }

    @Override
    public Object setAttribute(String name, Object value) {
        Object old;
        try (Locker.Lock ignored = this.locker.lock();){
            this.checkValidForWrite();
            old = this.sessionData.setAttribute(name, value);
        }
        if (value == null && old == null) {
            return null;
        }
        this.fireSessionAttributeListeners(name, old, value);
        return old;
    }

    @Override
    public Set<String> getAttributeNames() {
        try (Locker.Lock ignored = this.locker.lock();){
            this.checkValidForRead();
            Set<String> set = this.sessionData.getKeys();
            return set;
        }
    }

    @Override
    public Object removeAttribute(String name) {
        return this.setAttribute(name, null);
    }

    @Override
    public long getCreationTime() {
        try (Locker.Lock ignored = this.locker.lock();){
            this.checkValidForRead();
            long l = this.sessionData.getCreationTime();
            return l;
        }
    }

    @Override
    public long getLastAccessedTime() {
        try (Locker.Lock ignored = this.locker.lock();){
            long l = this.sessionData.getLastAccessedTime();
            return l;
        }
    }

    @Override
    public int getMaxInactiveInterval() {
        try (Locker.Lock ignored = this.locker.lock();){
            if (this.sessionData.getMaxInactiveInterval() > 0L) {
                int n = (int)(this.sessionData.getMaxInactiveInterval() / 1000L);
                return n;
            }
            int n = -1;
            return n;
        }
    }

    @Override
    public void setMaxInactiveInterval(int secs) {
        try (Locker.Lock ignored = this.locker.lock();){
            this.sessionData.setMaxInactiveInterval((long)secs * 1000L);
            this.sessionData.calcAndSetExpiry();
            this.sessionData.setDirty(true);
            if (log.isDebugEnabled()) {
                if (secs <= 0) {
                    log.debug("Session " + this.sessionData.getId() + " is now immortal (maxInactiveInterval=" + secs + ")");
                } else {
                    log.debug("Session " + this.sessionData.getId() + " maxInactiveInterval=" + secs);
                }
            }
        }
    }

    @Override
    public boolean access() {
        try (Locker.Lock ignored = this.locker.lock();){
            if (!this.isValid()) {
                boolean bl = false;
                return bl;
            }
            this.newSession = false;
            long now = System.currentTimeMillis();
            this.sessionData.setAccessedTime(now);
            this.sessionData.calcAndSetExpiry(now);
            if (this.isExpiredAt(now)) {
                this.invalidate();
                boolean bl = false;
                return bl;
            }
            ++this.requests;
            if (log.isDebugEnabled()) {
                log.debug("Session " + this.getId() + " accessed, stopping timer, active requests=" + this.requests);
            }
            this.sessionInactivityTimer.cancel();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void complete() {
        try (Locker.Lock ignored = this.locker.lock();){
            --this.requests;
            if (log.isDebugEnabled()) {
                log.debug("Session " + this.getId() + " complete, active requests=" + this.requests);
            }
            if (this.requests == 0) {
                long now = System.currentTimeMillis();
                this.sessionData.calcAndSetExpiry(now);
                this.sessionData.setLastAccessedTime(this.sessionData.getAccessedTime());
                this.sessionHandler.releaseSession(this);
                this.sessionInactivityTimer.schedule(this.calculateInactivityTimeout(now));
            }
        }
    }

    protected long getRequests() {
        try (Locker.Lock ignored = this.locker.lock();){
            long l = this.requests;
            return l;
        }
    }

    private long calculateInactivityTimeout(long now) {
        long time;
        try (Locker.Lock ignored = this.locker.lock();){
            long remaining = this.sessionData.getExpiryTime() - now;
            long maxInactive = this.sessionData.getMaxInactiveInterval();
            int evictionIdleSecs = this.sessionHandler.getSessionCache().getEvictionIdleSecs();
            if (maxInactive <= 0L) {
                if (evictionIdleSecs < 1) {
                    time = -1L;
                    if (log.isDebugEnabled()) {
                        log.debug("Session " + this.getId() + " is immortal && no inactivity eviction");
                    }
                } else {
                    time = TimeUnit.SECONDS.toMillis(evictionIdleSecs);
                    if (log.isDebugEnabled()) {
                        log.debug("Session " + this.getId() + " is immortal; evict after " + evictionIdleSecs + " sec inactivity");
                    }
                }
            } else if (evictionIdleSecs == -1) {
                long l = time = remaining > 0L ? remaining : 0L;
                if (log.isTraceEnabled()) {
                    log.trace("Session " + this.getId() + " no eviction");
                }
            } else if (evictionIdleSecs == 0) {
                time = -1L;
                if (log.isDebugEnabled()) {
                    log.debug("Session " + this.getId() + " evict on exit");
                }
            } else {
                long l = time = remaining > 0L ? Math.min(maxInactive, TimeUnit.SECONDS.toMillis(evictionIdleSecs)) : 0L;
                if (log.isDebugEnabled()) {
                    log.debug("Session " + this.getId() + " timer set to lesser of maxIdleSeconds=" + maxInactive / 1000L + " and evictionIdleSeconds=" + evictionIdleSecs);
                }
            }
        }
        return time;
    }

    @Override
    public void invalidate() {
        boolean result = this.beginInvalidate();
        if (result) {
            if (this.getDestroyedReason() == null) {
                this.setDestroyedReason(Session.DestroyedReason.INVALIDATED);
            }
            try {
                try {
                    this.sessionHandler.fireSessionDestroyedListeners(this);
                }
                finally {
                    this.finishInvalidate();
                }
                this.sessionHandler.removeSession(this.sessionData.getId(), false);
            }
            catch (Exception e) {
                log.warn("Failed to invalidate session", e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean beginInvalidate() {
        boolean result = false;
        try (Locker.Lock ignored = this.locker.lock();){
            switch (this.state) {
                case INVALID: {
                    throw new IllegalStateException();
                }
                case INVALIDATING: {
                    if (!log.isDebugEnabled()) return result;
                    log.debug("Session " + this.sessionData.getId() + " already being invalidated");
                    return result;
                }
                case VALID: {
                    this.state = State.INVALIDATING;
                    result = true;
                    return result;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishInvalidate() {
        try (Locker.Lock ignored = this.locker.lock();){
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Invalidate session " + this.sessionData.getId());
                }
                if (this.state == State.VALID || this.state == State.INVALIDATING) {
                    Set<String> keys;
                    do {
                        keys = this.sessionData.getKeys();
                        for (String key : keys) {
                            Object old = this.sessionData.setAttribute(key, null);
                            if (old == null) continue;
                            this.fireSessionAttributeListeners(key, old, null);
                        }
                    } while (!keys.isEmpty());
                }
            }
            finally {
                this.state = State.INVALID;
                this.sessionHandler.recordSessionTime(this);
            }
        }
    }

    @Override
    public Session.DestroyedReason getDestroyedReason() {
        return this.destroyedReason;
    }

    protected void setDestroyedReason(Session.DestroyedReason destroyedReason) {
        this.destroyedReason = destroyedReason;
    }

    @Override
    public boolean isNew() {
        try (Locker.Lock ignored = this.locker.lock();){
            this.checkValidForRead();
            boolean bl = this.newSession;
            return bl;
        }
    }

    @Override
    public boolean isValid() {
        try (Locker.Lock ignored = this.locker.lock();){
            boolean bl = this.state == State.VALID;
            return bl;
        }
    }

    protected boolean isResident() {
        return this.resident;
    }

    protected void setResident(boolean resident) {
        this.resident = resident;
        if (!resident) {
            this.sessionInactivityTimer.destroy();
        }
    }

    protected boolean isExpiredAt(long time) {
        try (Locker.Lock ignored = this.locker.lock();){
            this.checkValidForRead();
            boolean bl = this.sessionData.isExpiredAt(time);
            return bl;
        }
    }

    protected boolean isIdleLongerThan(int sec) {
        long now = System.currentTimeMillis();
        try (Locker.Lock ignored = this.locker.lock();){
            boolean bl = this.sessionData.getAccessedTime() + (long)(sec * 1000) <= now;
            return bl;
        }
    }

    protected void fireSessionAttributeListeners(String name, Object oldValue, Object newValue) {
        if (newValue == null || !newValue.equals(oldValue)) {
            if (oldValue != null) {
                this.unbindValue(name, oldValue);
            }
            if (newValue != null) {
                this.bindValue(name, newValue);
            }
        }
        this.sessionHandler.fireSessionAttributeListeners(this, name, oldValue, newValue);
    }

    protected void unbindValue(String name, Object value) {
        if (value instanceof SessionBindingListener) {
            ((SessionBindingListener)value).valueUnbound(this, name, value);
        }
    }

    protected void bindValue(String name, Object value) {
        if (value instanceof SessionBindingListener) {
            ((SessionBindingListener)value).valueBound(this, name, value);
        }
    }

    protected void checkValidForWrite() {
        this.checkLocked();
        if (this.state == State.INVALID) {
            throw new IllegalStateException("Not valid for write: session " + this);
        }
        if (this.state == State.INVALIDATING) {
            return;
        }
        if (!this.isResident()) {
            throw new IllegalStateException("Not valid for write: session " + this);
        }
    }

    protected void checkValidForRead() {
        this.checkLocked();
        if (this.state == State.INVALID) {
            throw new IllegalStateException("Invalid for read: session " + this);
        }
        if (this.state == State.INVALIDATING) {
            return;
        }
        if (!this.isResident()) {
            throw new IllegalStateException("Invalid for read: session " + this);
        }
    }

    protected void checkLocked() {
        if (!this.locker.isLocked()) {
            throw new IllegalStateException("Session not locked");
        }
    }

    protected Locker.Lock lock() {
        return this.locker.lock();
    }

    public String toString() {
        try (Locker.Lock ignored = this.locker.lock();){
            ToStringBuilder tsb = new ToStringBuilder(this.getClass().getSimpleName() + "@" + this.hashCode());
            tsb.append("id", this.sessionData.getId());
            tsb.append("state", (Object)this.state);
            tsb.append("requests", this.requests);
            tsb.append("resident", this.resident);
            String string = tsb.toString();
            return string;
        }
    }

    public class SessionInactivityTimer {
        protected final CyclicTimeout timer;

        SessionInactivityTimer() {
            this.timer = new CyclicTimeout(DefaultSession.this.getSessionHandler().getScheduler()){

                @Override
                public void onTimeoutExpired() {
                    if (log.isDebugEnabled()) {
                        log.debug("Timer expired for session " + DefaultSession.this.getId());
                    }
                    long now = System.currentTimeMillis();
                    DefaultSession.this.getSessionHandler().sessionInactivityTimerExpired(DefaultSession.this, now);
                    try (Locker.Lock ignored = DefaultSession.this.lock();){
                        if (DefaultSession.this.isResident() && DefaultSession.this.getRequests() <= 0L && DefaultSession.this.isValid() && !DefaultSession.this.isExpiredAt(now)) {
                            SessionInactivityTimer.this.schedule(DefaultSession.this.calculateInactivityTimeout(now));
                        }
                    }
                }
            };
        }

        public void schedule(long time) {
            if (time >= 0L) {
                if (log.isTraceEnabled()) {
                    log.trace("(Re)starting timer for session " + DefaultSession.this.getId() + " at " + time + "ms");
                }
                this.timer.schedule(time, TimeUnit.MILLISECONDS);
            } else if (log.isTraceEnabled()) {
                log.trace("Not starting timer for session " + DefaultSession.this.getId());
            }
        }

        public void cancel() {
            this.timer.cancel();
            if (log.isTraceEnabled()) {
                log.trace("Cancelled timer for session " + DefaultSession.this.getId());
            }
        }

        public void destroy() {
            this.timer.destroy();
            if (log.isTraceEnabled()) {
                log.trace("Destroyed timer for session " + DefaultSession.this.getId());
            }
        }
    }

    private static enum State {
        VALID,
        INVALID,
        INVALIDATING;

    }
}

