/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.AbstractSessionStore;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.UnreadableSessionDataException;
import com.aspectran.core.component.session.UnwritableSessionDataException;
import com.aspectran.core.util.MultiException;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class FileSessionStore
extends AbstractSessionStore {
    private static final Log log = LogFactory.getLog(FileSessionStore.class);
    private final Map<String, String> sessionFileMap = new ConcurrentHashMap<String, String>();
    private File storeDir;
    private boolean deleteUnrestorableFiles = true;
    private long lastSweepTime;

    public File getStoreDir() {
        return this.storeDir;
    }

    public void setStoreDir(File storeDir) {
        this.checkAlreadyInitialized();
        this.storeDir = storeDir;
    }

    public boolean isDeleteUnrestorableFiles() {
        return this.deleteUnrestorableFiles;
    }

    public void setDeleteUnrestorableFiles(boolean deleteUnrestorableFiles) {
        this.checkAlreadyInitialized();
        this.deleteUnrestorableFiles = deleteUnrestorableFiles;
    }

    @Override
    public SessionData load(String id) throws Exception {
        SessionData sessionData;
        String filename = this.sessionFileMap.get(id);
        if (filename == null) {
            if (log.isTraceEnabled()) {
                log.trace("Unknown file: " + id);
            }
            return null;
        }
        File file = new File(this.storeDir, filename);
        if (!file.exists()) {
            if (log.isDebugEnabled()) {
                log.debug("No such file: " + filename);
            }
            return null;
        }
        FileInputStream in = new FileInputStream(file);
        try {
            SessionData data = SessionData.deserialize(in);
            data.setLastSavedTime(file.lastModified());
            sessionData = data;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new UnreadableSessionDataException(id, e);
            }
        }
        in.close();
        return sessionData;
    }

    @Override
    public boolean delete(String id) throws Exception {
        if (this.storeDir != null) {
            String filename = this.sessionFileMap.remove(id);
            if (filename == null) {
                return false;
            }
            return this.deleteFile(filename);
        }
        return false;
    }

    private boolean deleteFile(String filename) throws Exception {
        if (filename == null) {
            return false;
        }
        File file = new File(this.storeDir, filename);
        return Files.deleteIfExists(file.toPath());
    }

    @Override
    public boolean exists(String id) {
        String filename = this.sessionFileMap.get(id);
        if (filename == null) {
            return false;
        }
        long expiry = this.getExpiryFromFilename(filename);
        if (expiry == 0L) {
            return true;
        }
        if (expiry == -1L) {
            return false;
        }
        return expiry > System.currentTimeMillis();
    }

    @Override
    public void doSave(String id, SessionData data, long lastSaveTime) throws Exception {
        if (this.storeDir != null) {
            this.delete(id);
            String filename = this.getIdWithExpiry(data);
            File file = new File(this.storeDir, filename);
            try (FileOutputStream fos = new FileOutputStream(file, false);){
                SessionData.serialize(data, fos, this.getNonPersistentAttributes());
                this.sessionFileMap.put(id, filename);
            }
            catch (Exception e) {
                file.delete();
                throw new UnwritableSessionDataException(id, e);
            }
        }
    }

    @Override
    public Set<String> doGetExpired(Set<String> candidates) {
        long now = System.currentTimeMillis();
        HashSet<String> expired = new HashSet<String>();
        for (String filename : this.sessionFileMap.values()) {
            try {
                long expiry = this.getExpiryFromFilename(filename);
                if (expiry <= 0L || expiry >= now) continue;
                expired.add(this.getIdFromFilename(filename));
            }
            catch (Exception e) {
                log.warn(e.getMessage(), e);
            }
        }
        for (String c : candidates) {
            String filename;
            if (expired.contains(c) || (filename = this.sessionFileMap.get(c)) != null) continue;
            expired.add(c);
        }
        if (this.getGracePeriodSecs() > 0 && (this.lastSweepTime == 0L || now - this.lastSweepTime >= 5L * TimeUnit.SECONDS.toMillis(this.getGracePeriodSecs()))) {
            this.lastSweepTime = now;
            this.sweepDisk();
        }
        return expired;
    }

    private String getIdWithExpiry(SessionData data) {
        if (data.getExpiryTime() > 0L) {
            return data.getExpiryTime() + "_" + data.getId();
        }
        return data.getId();
    }

    private long getExpiryFromFilename(String filename) {
        int index = filename.indexOf(95);
        if (index == -1) {
            return 0L;
        }
        try {
            String s = filename.substring(0, index);
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            log.warn("Not valid session filename: " + filename, e);
            return -1L;
        }
    }

    private String getIdFromFilename(String filename) {
        int index = filename.indexOf(95);
        if (index == -1) {
            return filename;
        }
        return filename.substring(index + 1);
    }

    private boolean isSessionFilename(String filename) {
        return StringUtils.hasText(filename) && !filename.startsWith(".");
    }

    private void sweepDisk() {
        long now = System.currentTimeMillis();
        if (log.isTraceEnabled()) {
            log.trace("Sweeping " + this.storeDir + " for old session files");
        }
        try {
            Files.walk(this.storeDir.toPath(), 1, FileVisitOption.FOLLOW_LINKS).filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> this.isSessionFilename(p.getFileName().toString())).forEach(p -> {
                try {
                    this.sweepFile(now, (Path)p);
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), e);
                }
            });
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
    }

    private void sweepFile(long now, Path p) throws Exception {
        if (p != null) {
            String filename = p.getFileName().toString();
            long expiry = this.getExpiryFromFilename(filename);
            if (expiry > 0L && now - expiry >= 5L * TimeUnit.SECONDS.toMillis(this.getGracePeriodSecs())) {
                Files.deleteIfExists(p);
                if (log.isDebugEnabled()) {
                    log.debug("Sweep expired session file: " + p.getFileName());
                }
            } else if (expiry == -1L && this.isDeleteUnrestorableFiles()) {
                Files.deleteIfExists(p);
                if (log.isDebugEnabled()) {
                    log.debug("Deleted unrestorable session file: " + p.getFileName());
                }
            }
        }
    }

    @Override
    protected void doInitialize() throws Exception {
        this.initializeStore();
    }

    @Override
    protected void doDestroy() {
        this.sessionFileMap.clear();
        this.lastSweepTime = 0L;
    }

    private void initializeStore() throws Exception {
        if (this.storeDir == null) {
            throw new IllegalStateException("No file store specified");
        }
        if (!this.storeDir.exists()) {
            this.storeDir.mkdirs();
            return;
        }
        if (!(this.storeDir.isDirectory() && this.storeDir.canWrite() && this.storeDir.canRead())) {
            throw new IllegalStateException(this.storeDir.getAbsolutePath() + " must be readable/writable directory");
        }
        MultiException me = new MultiException();
        long now = System.currentTimeMillis();
        Files.walk(this.storeDir.toPath(), 1, FileVisitOption.FOLLOW_LINKS).filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> this.isSessionFilename(p.getFileName().toString())).forEach(p -> {
            String filename;
            String sessionId;
            String existing;
            try {
                this.sweepFile(now, (Path)p);
            }
            catch (Exception x) {
                me.add(x);
            }
            if (Files.exists(p, new LinkOption[0]) && (existing = this.sessionFileMap.putIfAbsent(sessionId = this.getIdFromFilename(filename = p.getFileName().toString()), filename)) != null) {
                try {
                    long existingExpiry = this.getExpiryFromFilename(existing);
                    long thisExpiry = this.getExpiryFromFilename(filename);
                    if (thisExpiry > existingExpiry) {
                        Path existingPath = this.storeDir.toPath().resolve(existing);
                        this.sessionFileMap.put(sessionId, filename);
                        Files.delete(existingPath);
                        if (log.isDebugEnabled()) {
                            log.debug("Replaced " + existing + " with " + filename);
                        }
                    } else {
                        Files.delete(p);
                        if (log.isDebugEnabled()) {
                            log.debug("Deleted expired session file " + filename);
                        }
                    }
                }
                catch (IOException e) {
                    me.add(e);
                }
            }
        });
        me.ifExceptionThrow();
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("storeDir", this.storeDir);
        tsb.append("deleteUnrestorableFiles", this.deleteUnrestorableFiles);
        return tsb.toString();
    }
}

