/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.thread.Scheduler;
import java.util.concurrent.TimeUnit;

public class HouseKeeper {
    private static final Log log = LogFactory.getLog(HouseKeeper.class);
    private final SessionHandler sessionHandler;
    private final Scheduler scheduler;
    private Scheduler.Task task;
    private Runner runner;
    private long scavengingInterval = 600000L;

    public HouseKeeper(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
        this.scheduler = sessionHandler.getScheduler();
    }

    public int getScavengingInterval() {
        return (int)(this.scavengingInterval / 1000L);
    }

    public void setScavengingInterval(int intervalInSecs) {
        this.scavengingInterval = (long)intervalInSecs * 1000L;
    }

    public boolean isScavengable() {
        return this.scavengingInterval > 0L;
    }

    public void startScavenging() {
        this.startScavenging(this.getScavengingInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScavenging(int intervalInSecs) {
        HouseKeeper houseKeeper = this;
        synchronized (houseKeeper) {
            if (intervalInSecs < 10) {
                log.warn(this.sessionHandler.getComponentName() + " Short interval of " + intervalInSecs + "sec for session scavenging");
            }
            this.setScavengingInterval(intervalInSecs);
            if (this.task != null) {
                this.task.cancel();
            }
            if (this.runner == null) {
                this.runner = new Runner();
            }
            log.info(this.sessionHandler.getComponentName() + " Scavenging every " + this.scavengingInterval + " ms");
            this.task = this.scheduler.schedule(this.runner, this.scavengingInterval, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScavenging() {
        HouseKeeper houseKeeper = this;
        synchronized (houseKeeper) {
            if (this.task != null) {
                this.task.cancel();
                log.info(this.sessionHandler.getComponentName() + " Stopped scavenging");
            }
            this.task = null;
        }
        this.runner = null;
    }

    private void scavenge() {
        if (!this.scheduler.isRunning()) {
            return;
        }
        try {
            this.sessionHandler.scavenge();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(super.toString());
        tsb.append("scavengingInterval", this.scavengingInterval);
        return tsb.toString();
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            try {
                HouseKeeper.this.scavenge();
            }
            finally {
                if (HouseKeeper.this.scheduler != null && HouseKeeper.this.scheduler.isRunning()) {
                    HouseKeeper.this.task = HouseKeeper.this.scheduler.schedule(this, HouseKeeper.this.scavengingInterval, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

