/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.NonPersistent;
import com.aspectran.core.util.CustomObjectInputStream;
import com.aspectran.core.util.ToStringBuilder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionData
implements Serializable {
    private static final long serialVersionUID = -6253355753257200708L;
    private String id;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final long creationTime;
    private long accessedTime;
    private long lastAccessedTime;
    private long maxInactiveInterval;
    private long expiryTime;
    private boolean dirty;
    private long lastSavedTime;

    public SessionData(String id, long creationTime, long accessedTime, long lastAccessedTime, long maxInactiveInterval) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.id = id;
        this.creationTime = creationTime;
        this.accessedTime = accessedTime;
        this.lastAccessedTime = lastAccessedTime;
        this.maxInactiveInterval = maxInactiveInterval;
        this.calcAndSetExpiry(creationTime);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public <T> T setAttribute(String name, Object value) {
        Object old = value == null ? this.attributes.remove(name) : this.attributes.put(name, value);
        if (value == null && old == null) {
            return null;
        }
        this.setDirty(true);
        return (T)old;
    }

    public Set<String> getKeys() {
        return this.attributes.keySet();
    }

    public Map<String, Object> getAllAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void putAllAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
    }

    public void clearAllAttributes() {
        this.attributes.clear();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getAccessedTime() {
        return this.accessedTime;
    }

    public void setAccessedTime(long accessedTime) {
        this.accessedTime = accessedTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public long getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(long maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long calcExpiry() {
        return this.calcExpiry(System.currentTimeMillis());
    }

    public long calcExpiry(long time) {
        return this.maxInactiveInterval <= 0L ? 0L : time + this.maxInactiveInterval;
    }

    public void calcAndSetExpiry() {
        this.setExpiryTime(this.calcExpiry());
    }

    public void calcAndSetExpiry(long time) {
        this.setExpiryTime(this.calcExpiry(time));
    }

    public boolean isExpiredAt(long time) {
        if (this.maxInactiveInterval <= 0L) {
            return false;
        }
        return this.expiryTime <= time;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public long getLastSavedTime() {
        return this.lastSavedTime;
    }

    public void setLastSavedTime(long lastSavedTime) {
        this.lastSavedTime = lastSavedTime;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("id", this.getId());
        tsb.append("created", this.getCreationTime());
        tsb.append("accessed", this.getLastAccessedTime());
        tsb.append("lastAccessed", this.getLastAccessedTime());
        tsb.append("maxInactiveInterval", this.getMaxInactiveInterval());
        tsb.append("expiry", this.getExpiryTime());
        return tsb.toString();
    }

    public static void serialize(SessionData data, OutputStream os, Set<String> nonPersistentAttributes) throws IOException {
        DataOutputStream out = new DataOutputStream(os);
        out.writeUTF(data.getId());
        out.writeLong(data.getCreationTime());
        out.writeLong(data.getAccessedTime());
        out.writeLong(data.getLastAccessedTime());
        out.writeLong(data.getExpiryTime());
        out.writeLong(data.getMaxInactiveInterval());
        Set<String> keys = data.getKeys();
        if (keys.isEmpty()) {
            out.writeInt(0);
            return;
        }
        ArrayList<String> attrKeys = new ArrayList<String>(keys);
        if (nonPersistentAttributes != null && !attrKeys.isEmpty()) {
            attrKeys.removeAll(nonPersistentAttributes);
        }
        for (String name : attrKeys) {
            Object value = data.getAttribute(name);
            if (!(value instanceof NonPersistent)) continue;
            attrKeys.remove(name);
        }
        out.writeInt(attrKeys.size());
        if (!attrKeys.isEmpty()) {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            for (String name : attrKeys) {
                Object value = data.getAttribute(name);
                oos.writeUTF(name);
                oos.writeObject(value);
            }
        }
    }

    public static SessionData deserialize(InputStream is) throws Exception {
        DataInputStream dis = new DataInputStream(is);
        String id = dis.readUTF();
        long created = dis.readLong();
        long accessed = dis.readLong();
        long lastAccessed = dis.readLong();
        long expiry = dis.readLong();
        long maxInactive = dis.readLong();
        int entries = dis.readInt();
        SessionData data = new SessionData(id, created, accessed, lastAccessed, maxInactive);
        data.setExpiryTime(expiry);
        data.setMaxInactiveInterval(maxInactive);
        SessionData.restoreAttributes(dis, entries, data);
        return data;
    }

    private static void restoreAttributes(InputStream is, int entries, SessionData data) throws Exception {
        if (entries > 0) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            CustomObjectInputStream ois = new CustomObjectInputStream(is);
            for (int i = 0; i < entries; ++i) {
                String key = ois.readUTF();
                Object value = ois.readObject();
                attributes.put(key, value);
            }
            data.putAllAttributes(attributes);
        }
    }
}

