/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.expr;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityDataMap;
import com.aspectran.core.context.expr.ognl.OgnlSupport;
import com.aspectran.core.context.rule.ChooseWhenRule;
import com.aspectran.core.context.rule.IllegalRuleException;

public class BooleanExpression {
    protected final Activity activity;

    public BooleanExpression(Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("activity must not be null");
        }
        this.activity = activity;
    }

    public boolean evaluate(ChooseWhenRule chooseWhenRule) throws IllegalRuleException {
        if (chooseWhenRule.getExpression() == null) {
            return true;
        }
        ActivityDataMap root = this.activity.getTranslet() != null ? this.activity.getTranslet().getActivityDataMap() : null;
        return OgnlSupport.evaluateAsBoolean(chooseWhenRule.getExpression(), chooseWhenRule.getRepresented(), root);
    }

    public static Object parseExpression(String expression) throws IllegalRuleException {
        return OgnlSupport.parseExpression(expression);
    }
}

