/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.expr.ognl;

import com.aspectran.core.context.expr.ognl.OgnlMemberAccess;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.util.ConcurrentReferenceHashMap;
import com.aspectran.core.util.StringUtils;
import java.util.Map;
import ognl.ClassResolver;
import ognl.DefaultClassResolver;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlException;

public class OgnlSupport {
    private static final OgnlMemberAccess MEMBER_ACCESS = new OgnlMemberAccess();
    private static final DefaultClassResolver CLASS_RESOLVER = new DefaultClassResolver();
    private static final Map<String, Object> cache = new ConcurrentReferenceHashMap<String, Object>();

    private OgnlSupport() {
    }

    public static Object parseExpression(String expression) throws IllegalRuleException {
        if (!StringUtils.hasLength(expression)) {
            return null;
        }
        try {
            Object existing;
            Object node = cache.get(expression);
            if (node == null && (existing = cache.putIfAbsent(expression, node = Ognl.parseExpression((String)expression))) != null) {
                node = existing;
            }
            return node;
        }
        catch (OgnlException e) {
            throw new IllegalRuleException("Error parsing expression '" + expression + "'. Cause: " + (Object)((Object)e), e);
        }
    }

    public static Boolean evaluateAsBoolean(String expression, Object root) throws IllegalRuleException {
        return OgnlSupport.evaluateAsBoolean(expression, null, root);
    }

    public static Boolean evaluateAsBoolean(String expression, Object represented, Object root) throws IllegalRuleException {
        if (represented == null) {
            represented = OgnlSupport.parseExpression(expression);
        }
        if (represented == null) {
            return false;
        }
        try {
            Map context = OgnlSupport.createDefaultContext(root);
            return (Boolean)Ognl.getValue((Object)represented, (Map)context, (Object)root, Boolean.class);
        }
        catch (OgnlException e) {
            throw new IllegalRuleException("Error evaluating expression '" + expression + "'. Cause: " + (Object)((Object)e), e);
        }
    }

    private static Map createDefaultContext(Object root) {
        return Ognl.createDefaultContext((Object)root, (MemberAccess)MEMBER_ACCESS, (ClassResolver)CLASS_RESOLVER, null);
    }
}

