/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.expr.token;

import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.Tokenizer;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.util.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TokenParser {
    public static Token[] parse(String text) {
        return TokenParser.parse(text, false);
    }

    public static Token[] parse(String text, boolean optimize) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            Token t = new Token(text);
            return new Token[]{t};
        }
        Token[] tokens = null;
        List<Token> tokenList = Tokenizer.tokenize(text, optimize);
        if (!tokenList.isEmpty()) {
            tokens = tokenList.toArray(new Token[0]);
            if (optimize) {
                tokens = Tokenizer.optimize(tokens);
            }
        }
        return tokens;
    }

    public static List<Token[]> parseAsList(String text) {
        if (text == null) {
            return null;
        }
        List<Token> tokenList = Tokenizer.tokenize(text, true);
        ArrayList<Token[]> tokensList = null;
        if (!tokenList.isEmpty()) {
            tokensList = new ArrayList<Token[]>();
            for (Token t : tokenList) {
                if (t.getType() == TokenType.TEXT) {
                    if (!StringUtils.hasText(t.getDefaultValue())) continue;
                    tokensList.add(new Token[]{t});
                    continue;
                }
                tokensList.add(new Token[]{t});
            }
        }
        return tokensList == null || tokensList.isEmpty() ? null : tokensList;
    }

    public static Map<String, Token[]> parseAsMap(String text) {
        if (text == null) {
            return null;
        }
        List<Token> tokenList = Tokenizer.tokenize(text, true);
        LinkedHashMap<String, Token[]> tokensMap = null;
        if (!tokenList.isEmpty()) {
            tokensMap = new LinkedHashMap<String, Token[]>();
            for (Token t : tokenList) {
                if (t.getType() == TokenType.TEXT || !StringUtils.hasLength(t.getName()) || !StringUtils.hasLength(t.getDefaultValue())) continue;
                tokensMap.put(t.getName(), new Token[]{t});
            }
        }
        return tokensMap == null || tokensMap.isEmpty() ? null : tokensMap;
    }

    public static Token[] makeTokens(String text, boolean tokenize) {
        if (text == null) {
            return null;
        }
        Token[] tokens = tokenize ? TokenParser.parse(text) : new Token[]{new Token(text)};
        return tokens;
    }

    public static String toString(Token[] tokens) {
        if (tokens == null || tokens.length == 0) {
            return "";
        }
        if (tokens.length == 1) {
            return tokens[0] == null ? "" : tokens[0].stringify();
        }
        StringBuilder sb = new StringBuilder();
        for (Token t : tokens) {
            if (t == null) continue;
            sb.append(t.stringify());
        }
        return sb.toString();
    }
}

