/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.resource;

import com.aspectran.core.context.resource.AspectranClassLoader;
import com.aspectran.core.context.resource.InvalidResourceException;
import com.aspectran.core.context.resource.ResourceEntries;
import com.aspectran.core.util.StringUtils;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;

public class ResourceManager {
    private final ResourceEntries resourceEntries = new ResourceEntries();

    public URL getResource(String name) {
        return (URL)this.resourceEntries.get(name);
    }

    public static Enumeration<URL> getResources(final Iterator<AspectranClassLoader> owners) {
        return new Enumeration<URL>(){
            private Iterator<URL> values;
            private URL next;
            private URL current;

            private boolean hasNext() {
                while (true) {
                    if (this.values == null) {
                        if (!owners.hasNext()) {
                            return false;
                        }
                        this.values = ((AspectranClassLoader)owners.next()).getResourceManager().getResourceEntries().values().iterator();
                    }
                    if (this.values.hasNext()) {
                        this.next = this.values.next();
                        return true;
                    }
                    this.values = null;
                }
            }

            @Override
            public synchronized boolean hasMoreElements() {
                return this.next != null || this.hasNext();
            }

            @Override
            public synchronized URL nextElement() {
                if (this.next == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = null;
                return this.current;
            }
        };
    }

    public static Enumeration<URL> getResources(Iterator<AspectranClassLoader> owners, String name) {
        return ResourceManager.getResources(owners, name, null);
    }

    public static Enumeration<URL> getResources(final Iterator<AspectranClassLoader> owners, String name, final Enumeration<URL> inherited) {
        if (owners == null || name == null) {
            return Collections.emptyEnumeration();
        }
        if (StringUtils.endsWith(name, '/')) {
            name = name.substring(0, name.length() - 1);
        }
        final String nameToSearch = name;
        return new Enumeration<URL>(){
            private URL next;
            private URL current;
            private boolean noMore;

            private boolean hasNext() {
                do {
                    if (!owners.hasNext()) {
                        return false;
                    }
                    this.next = ((AspectranClassLoader)owners.next()).getResourceManager().getResource(nameToSearch);
                } while (this.next == null);
                return true;
            }

            @Override
            public boolean hasMoreElements() {
                if (!this.noMore) {
                    if (inherited != null && inherited.hasMoreElements()) {
                        return true;
                    }
                    this.noMore = true;
                }
                return this.next != null || this.hasNext();
            }

            @Override
            public URL nextElement() {
                if (!this.noMore && inherited != null && inherited.hasMoreElements()) {
                    return (URL)inherited.nextElement();
                }
                if (this.next == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = null;
                return this.current;
            }
        };
    }

    public static Enumeration<URL> searchResources(Iterator<AspectranClassLoader> owners, String name) {
        return ResourceManager.searchResources(owners, name, null);
    }

    public static Enumeration<URL> searchResources(final Iterator<AspectranClassLoader> owners, String name, final Enumeration<URL> inherited) {
        if (StringUtils.endsWith(name, '/')) {
            name = name.substring(0, name.length() - 1);
        }
        final String nameToSearch = name;
        return new Enumeration<URL>(){
            private Iterator<Map.Entry<String, URL>> current;
            private Map.Entry<String, URL> entry;
            private boolean noMore;

            private boolean hasNext() {
                while (true) {
                    if (this.current == null) {
                        if (!owners.hasNext()) {
                            return false;
                        }
                        this.current = ((AspectranClassLoader)owners.next()).getResourceManager().getResourceEntries().entrySet().iterator();
                    }
                    while (this.current.hasNext()) {
                        Map.Entry<String, URL> entry2 = this.current.next();
                        if (!entry2.getKey().equals(nameToSearch)) continue;
                        this.entry = entry2;
                        return true;
                    }
                    this.current = null;
                }
            }

            @Override
            public synchronized boolean hasMoreElements() {
                if (this.entry != null) {
                    return true;
                }
                if (!this.noMore) {
                    if (inherited != null && inherited.hasMoreElements()) {
                        return true;
                    }
                    this.noMore = true;
                }
                return this.hasNext();
            }

            @Override
            public synchronized URL nextElement() {
                if (this.entry == null) {
                    if (!this.noMore && inherited != null && inherited.hasMoreElements()) {
                        return (URL)inherited.nextElement();
                    }
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                URL url = this.entry.getValue();
                this.entry = null;
                return url;
            }
        };
    }

    protected ResourceEntries getResourceEntries() {
        return this.resourceEntries;
    }

    public int getNumberOfResources() {
        return this.resourceEntries.size();
    }

    protected void putResource(String resourceName, File file) throws InvalidResourceException {
        this.resourceEntries.putResource(resourceName, file);
    }

    protected void putResource(File file, JarEntry entry) throws InvalidResourceException {
        this.resourceEntries.putResource(file, entry);
    }

    public void reset() throws InvalidResourceException {
        this.release();
    }

    public void release() {
        this.resourceEntries.clear();
    }
}

