/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.type.PointcutType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import java.util.List;

public class PointcutPatternRule {
    private static final char POINTCUT_BEAN_CLASS_DELIMITER = '@';
    private static final char POINTCUT_METHOD_NAME_DELIMITER = '^';
    private PointcutType pointcutType;
    private String patternString;
    private String transletNamePattern;
    private String beanIdPattern;
    private String classNamePattern;
    private String methodNamePattern;
    private int matchedBeanCount;
    private int matchedClassCount;
    private int matchedMethodCount;
    private List<PointcutPatternRule> excludePointcutPatternRuleList;

    public PointcutType getPointcutType() {
        return this.pointcutType;
    }

    protected void setPointcutType(PointcutType pointcutType) {
        this.pointcutType = pointcutType;
    }

    public String getPatternString() {
        return this.patternString;
    }

    public void setPatternString(String patternString) {
        this.patternString = patternString;
    }

    public String getTransletNamePattern() {
        return this.transletNamePattern;
    }

    public void setTransletNamePattern(String transletNamePattern) {
        this.transletNamePattern = StringUtils.emptyToNull(transletNamePattern);
    }

    public String getBeanIdPattern() {
        return this.beanIdPattern;
    }

    public void setBeanIdPattern(String beanIdPattern) {
        this.beanIdPattern = StringUtils.emptyToNull(beanIdPattern);
    }

    public String getClassNamePattern() {
        return this.classNamePattern;
    }

    public void setClassNamePattern(String classNamePattern) {
        this.classNamePattern = StringUtils.emptyToNull(classNamePattern);
    }

    public String getMethodNamePattern() {
        return this.methodNamePattern;
    }

    public void setMethodNamePattern(String methodNamePattern) {
        this.methodNamePattern = StringUtils.emptyToNull(methodNamePattern);
    }

    public List<PointcutPatternRule> getExcludePointcutPatternRuleList() {
        return this.excludePointcutPatternRuleList;
    }

    public void setExcludePointcutPatternRuleList(List<PointcutPatternRule> excludePointcutPatternRuleList) {
        this.excludePointcutPatternRuleList = excludePointcutPatternRuleList;
    }

    public int getMatchedBeanCount() {
        return this.matchedBeanCount;
    }

    public void increaseMatchedBeanCount() {
        ++this.matchedBeanCount;
    }

    public int getMatchedClassCount() {
        return this.matchedClassCount;
    }

    public void increaseMatchedClassCount() {
        ++this.matchedClassCount;
    }

    public int getMatchedMethodCount() {
        return this.matchedMethodCount;
    }

    public void increaseMatchedMethodCount() {
        ++this.matchedMethodCount;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("translet", this.transletNamePattern);
        tsb.append("bean", this.beanIdPattern);
        tsb.append("class", this.classNamePattern);
        tsb.append("method", this.methodNamePattern);
        tsb.append("excludes", this.excludePointcutPatternRuleList);
        return tsb.toString();
    }

    public static String combinePattern(String transletName, String beanId, String className, String methodName) {
        int len = 0;
        if (transletName != null && transletName.length() > 0) {
            len += transletName.length();
        }
        if (beanId != null && beanId.length() > 0) {
            len += beanId.length() + 1;
        } else if (className != null && className.length() > 0) {
            len += className.length() + 7;
        }
        if (methodName != null && methodName.length() > 0) {
            len += methodName.length() + 1;
        }
        StringBuilder sb = new StringBuilder(len);
        if (transletName != null && transletName.length() > 0) {
            sb.append(transletName);
        }
        if (beanId != null && beanId.length() > 0) {
            sb.append('@');
            sb.append(beanId);
        } else if (className != null && className.length() > 0) {
            sb.append('@');
            sb.append("class:");
            sb.append(className);
        }
        if (methodName != null && methodName.length() > 0) {
            sb.append('^');
            sb.append(methodName);
        }
        return sb.toString();
    }

    public static PointcutPatternRule parsePattern(String patternString) {
        PointcutPatternRule ppr = new PointcutPatternRule();
        ppr.setPatternString(patternString);
        String transletNamePattern = null;
        String beanClassPattern = null;
        String methodNamePattern = null;
        int beanClassDelimiterIndex = patternString.indexOf(64);
        if (beanClassDelimiterIndex == -1) {
            transletNamePattern = patternString;
        } else if (beanClassDelimiterIndex == 0) {
            beanClassPattern = patternString.substring(1);
        } else {
            transletNamePattern = patternString.substring(0, beanClassDelimiterIndex);
            beanClassPattern = patternString.substring(beanClassDelimiterIndex + 1);
        }
        if (beanClassPattern != null) {
            int methodNameDelimiterIndex = beanClassPattern.indexOf(94);
            if (methodNameDelimiterIndex == 0) {
                methodNamePattern = beanClassPattern.substring(1);
                beanClassPattern = null;
            } else if (methodNameDelimiterIndex > 0) {
                methodNamePattern = beanClassPattern.substring(methodNameDelimiterIndex + 1);
                beanClassPattern = beanClassPattern.substring(0, methodNameDelimiterIndex);
            }
        }
        if (transletNamePattern != null) {
            ppr.setTransletNamePattern(transletNamePattern);
        }
        if (beanClassPattern != null) {
            if (beanClassPattern.startsWith("class:")) {
                String className = beanClassPattern.substring("class:".length());
                ppr.setClassNamePattern(className);
            } else {
                ppr.setBeanIdPattern(beanClassPattern);
            }
        }
        if (methodNamePattern != null) {
            ppr.setMethodNamePattern(methodNamePattern);
        }
        return ppr;
    }

    public static PointcutPatternRule newInstance(String translet, String bean, String method) {
        PointcutPatternRule ppr = new PointcutPatternRule();
        if (translet != null) {
            ppr.setTransletNamePattern(translet);
        }
        if (bean != null) {
            if (bean.startsWith("class:")) {
                String className = bean.substring("class:".length());
                ppr.setClassNamePattern(className);
            } else {
                ppr.setBeanIdPattern(bean);
            }
        }
        if (method != null) {
            ppr.setMethodNamePattern(method);
        }
        return ppr;
    }
}

