/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser;

import com.aspectran.core.context.rule.appender.AbstractRuleAppender;
import com.aspectran.core.context.rule.appender.FileRuleAppender;
import com.aspectran.core.context.rule.appender.ResourceRuleAppender;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.parser.ActivityContextParser;
import com.aspectran.core.context.rule.type.AppendedFileFormatType;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;

public abstract class AbstractActivityContextParser
implements ActivityContextParser {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final ContextRuleAssistant assistant;
    private String encoding;
    private boolean useXmlToApon;
    private boolean debugMode;

    public AbstractActivityContextParser(ContextRuleAssistant assistant) {
        this.assistant = assistant;
    }

    @Override
    public ContextRuleAssistant getContextRuleAssistant() {
        return this.assistant;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected boolean isUseXmlToApon() {
        return this.useXmlToApon;
    }

    @Override
    public void setUseXmlToApon(boolean useXmlToApon) {
        this.useXmlToApon = useXmlToApon;
    }

    protected boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    protected RuleAppender resolveAppender(String configFile) {
        AbstractRuleAppender appender;
        if (configFile.startsWith("classpath:")) {
            String resource = configFile.substring("classpath:".length());
            appender = new ResourceRuleAppender(resource, this.assistant.getClassLoader());
        } else if (configFile.startsWith("file:")) {
            String filePath = configFile.substring("file:".length());
            appender = new FileRuleAppender(filePath);
        } else {
            appender = new FileRuleAppender(this.assistant.getBasePath(), configFile);
        }
        if (configFile.toLowerCase().endsWith(".apon")) {
            appender.setAppendedFileFormatType(AppendedFileFormatType.APON);
        } else {
            appender.setAppendedFileFormatType(AppendedFileFormatType.XML);
        }
        return appender;
    }
}

